/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.ReturnValue;

final class MapMethodsSupport {
    static <K, V> void returnCurrentValueIfPresent(MapQueryContext<K, V> q, ReturnValue<? super V> returnValue) {
        MapEntry<K, V> entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
        }
    }

    static <K, V> boolean tryReturnCurrentValueIfPresent(MapQueryContext<K, V> q, ReturnValue<? super V> returnValue) {
        MapEntry<K, V> entry;
        if (q.readLock().tryLock()) {
            entry = q.entry();
            if (entry != null) {
                returnValue.returnValue(entry.value());
                return true;
            }
            q.readLock().unlock();
        }
        q.updateLock().lock();
        entry = q.entry();
        if (entry != null) {
            returnValue.returnValue(entry.value());
            return true;
        }
        return false;
    }

    private MapMethodsSupport() {
    }
}

