/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.map.ChronicleMapEventListener;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import org.jetbrains.annotations.NotNull;

public class ChronicleMapEventsProducer<K, V>
implements MapEntryOperations<K, V> {
    private final Map<ChronicleMapEventListener, Set<K>> listeners = new ConcurrentHashMap<ChronicleMapEventListener, Set<K>>();
    private final K ALL_EVENTS = new Object();

    public void addMapEventListener(ChronicleMapEventListener listener) {
        this.addMapEventListener(listener, this.ALL_EVENTS);
    }

    public void addMapEventListener(ChronicleMapEventListener listener, K key) {
        this.listeners.compute(listener, (k, v) -> {
            if (v == null) {
                v = new HashSet<Object>();
            }
            v.add(key);
            return v;
        });
    }

    public void removeMapEventListener(ChronicleMapEventListener listener) {
        this.listeners.remove(listener);
    }

    public void removeMapEventListener(ChronicleMapEventListener listener, K key) {
        this.listeners.compute(listener, (k, v) -> {
            if (v == null) {
                return null;
            }
            if (v.size() == 0) {
                return null;
            }
            v.remove(key);
            return v;
        });
    }

    @Override
    public boolean replaceValue(@NotNull MapEntry<K, V> entry, Value<V, ?> newValue) {
        Object oldEntry = entry.value().get();
        if (MapEntryOperations.super.replaceValue(entry, newValue)) {
            this.listeners.entrySet().stream().filter(e -> e.getValue() == this.ALL_EVENTS || ((Set)e.getValue()).equals(entry.key().get())).forEach(e -> {
                if (oldEntry == null) {
                    ((ChronicleMapEventListener)e.getKey()).insert(entry.key().get(), newValue.get());
                } else {
                    ((ChronicleMapEventListener)e.getKey()).update(entry.key(), oldEntry, newValue.get());
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(@NotNull MapEntry<K, V> entry) {
        Object oldEntry = entry.value().get();
        if (MapEntryOperations.super.remove(entry)) {
            this.listeners.entrySet().stream().filter(e -> e.getValue() == this.ALL_EVENTS || ((Set)e.getValue()).equals(entry.key().get())).forEach(e -> ((ChronicleMapEventListener)e.getKey()).remove(entry.key(), oldEntry));
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        ChronicleMapEventsProducer producer = new ChronicleMapEventsProducer();
        TestListener testListener = new TestListener();
        producer.addMapEventListener((key, oldValue, newValue) -> System.out.print(key));
        producer.addMapEventListener((key, oldValue, newValue) -> System.out.print(key), "test");
        producer.addMapEventListener(testListener);
        producer.addMapEventListener(testListener);
        producer.addMapEventListener(testListener, "test");
        producer.addMapEventListener(testListener, "test");
        producer.removeMapEventListener(testListener, "test");
        System.out.println("end");
    }

    private static class TestListener
    implements ChronicleMapEventListener {
        private TestListener() {
        }

        public void update(Object key, Object oldValue, Object newValue) {
            System.out.print(key);
        }
    }
}

