/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.function.SerializableFunction;
import net.openhft.chronicle.hash.impl.HashContext;
import net.openhft.chronicle.hash.impl.hashlookup.HashLookupIteration;
import net.openhft.chronicle.hash.impl.util.CharSequences;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapEntrySet;
import net.openhft.chronicle.map.ChronicleMapIterator;
import net.openhft.chronicle.map.JsonSerializer;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.VanillaContext;
import org.jetbrains.annotations.NotNull;

interface AbstractChronicleMap<K, V>
extends ChronicleMap<K, V>,
Serializable {
    @Override
    public VanillaContext<K, ?, ?, V, ?, ?> context(K var1);

    @Override
    default public boolean containsKey(Object key) {
        try (KeyContext c = this.context(key);){
            boolean bl = c.containsKey();
            return bl;
        }
    }

    @Override
    default public V put(K key, V value) {
        try (KeyContext c = this.context((Object)key);){
            c.updateLock().lock();
            V prevValue = this.prevValueOnPut((MapKeyContext<K, V>)c);
            c.put(value);
            V v = prevValue;
            return v;
        }
    }

    default public V prevValueOnPut(MapKeyContext<K, V> context) {
        return context.getUsing(null);
    }

    @Override
    default public V putIfAbsent(K key, V value) {
        this.checkValue(value);
        try (KeyContext c = this.context((Object)key);){
            V currentValue;
            if (c.readLock().tryLock()) {
                currentValue = c.getUsing(null);
                if (currentValue != null) {
                    V v = currentValue;
                    return v;
                }
                this.upgradeReadToUpdateLockWithUnlockingIfNeeded(c);
            }
            if ((currentValue = c.getUsing(null)) != null) {
                V v = currentValue;
                return v;
            }
            c.put(value);
            V v = null;
            return v;
        }
    }

    public void checkValue(V var1);

    @Override
    default public V get(Object key) {
        return this.getUsing(key, null);
    }

    @Override
    default public V getUsing(K key, V usingValue) {
        try (KeyContext c = this.context((Object)key);){
            V v = c.getUsing(usingValue);
            return v;
        }
    }

    @Override
    default public V acquireUsing(K key, V usingValue) {
        try (KeyContext c = this.context((Object)key);){
            V value;
            if (((HashContext)c).readLock().tryLock()) {
                value = ((VanillaContext)c).getUsing(usingValue);
                if (value != null) {
                    V v = value;
                    return v;
                }
                this.upgradeReadToUpdateLockWithUnlockingIfNeeded(c);
            } else {
                ((HashContext)c).updateLock().lock();
            }
            value = ((VanillaContext)c).getUsing(usingValue);
            if (value != null) {
                V v = value;
                return v;
            }
            this.putDefaultValue((VanillaContext)c);
            V v = ((VanillaContext)c).getUsing(usingValue);
            return v;
        }
    }

    default public void upgradeReadToUpdateLockWithUnlockingIfNeeded(KeyContext c) {
        if (!c.updateLock().tryLock()) {
            c.readLock().unlock();
            c.updateLock().lock();
        }
    }

    public void putDefaultValue(VanillaContext var1);

    @Override
    default public <R> R getMapped(K key, @NotNull SerializableFunction<? super V, R> function) {
        Objects.requireNonNull(function);
        try (KeyContext c = this.context((Object)key);){
            R r = c.containsKey() ? (R)function.apply((V)c.get()) : null;
            return r;
        }
    }

    @Override
    default public V putMapped(K key, @NotNull UnaryOperator<V> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        try (KeyContext c = this.context((Object)key);){
            c.updateLock().lock();
            if (c.containsKey()) {
                V newValue = unaryOperator.update(c.get());
                c.put(newValue);
                V v = newValue;
                return v;
            }
            V v = null;
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void getAll(File toFile) throws IOException {
        AbstractChronicleMap abstractChronicleMap = this;
        synchronized (abstractChronicleMap) {
            JsonSerializer.getAll(toFile, this, Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void putAll(File fromFile) throws IOException {
        AbstractChronicleMap abstractChronicleMap = this;
        synchronized (abstractChronicleMap) {
            JsonSerializer.putAll(fromFile, this, Collections.emptyList());
        }
    }

    @Override
    default public V remove(Object key) {
        try (KeyContext c = this.context(key);){
            c.updateLock().lock();
            V prevValue = this.prevValueOnRemove((MapKeyContext<K, V>)c);
            c.remove();
            V v = prevValue;
            return v;
        }
    }

    default public V prevValueOnRemove(MapKeyContext<K, V> context) {
        return context.getUsing(null);
    }

    @Override
    default public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        this.checkValue(value);
        try (KeyContext c = this.context(key);){
            c.updateLock().lock();
            boolean bl = c.containsKey() && c.valueEqualTo(value) && c.remove();
            return bl;
        }
    }

    @Override
    default public V replace(K key, V value) {
        this.checkValue(value);
        try (KeyContext c = this.context((Object)key);){
            c.updateLock().lock();
            V prevValue = c.getUsing(null);
            if (prevValue != null) {
                c.put(value);
            }
            V v = prevValue;
            return v;
        }
    }

    @Override
    default public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        this.checkValue(newValue);
        try (KeyContext c = this.context((Object)key);){
            c.updateLock().lock();
            boolean bl = c.containsKey() && c.valueEqualTo(oldValue) && c.put(newValue);
            return bl;
        }
    }

    public int actualSegments();

    public VanillaContext<K, ?, ?, V, ?, ?> mapContext();

    @Override
    default public boolean containsValue(Object value) {
        return !this.forEachEntryWhile((Predicate<? super MapKeyContext<K, V>>)((Predicate<MapKeyContext>)c -> !c.valueEqualTo(value)));
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.forEachEntry((Consumer<? super MapKeyContext<K, V>>)((Consumer<MapKeyContext>)c -> action.accept((Object)c.key(), (Object)c.get())));
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    @NotNull
    default public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<Map.Entry<K, V>> i;
                    {
                        this.i = AbstractChronicleMap.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.i.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractChronicleMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AbstractChronicleMap.this.isEmpty();
            }

            @Override
            public void clear() {
                AbstractChronicleMap.this.clear();
            }

            @Override
            public boolean contains(Object v) {
                return AbstractChronicleMap.this.containsValue(v);
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                AbstractChronicleMap.this.forEachEntry(c -> action.accept((Object)c.get()));
            }
        };
    }

    @Override
    @NotNull
    default public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new ChronicleMapIterator.OfKeys(AbstractChronicleMap.this);
            }

            @Override
            public int size() {
                return AbstractChronicleMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return AbstractChronicleMap.this.isEmpty();
            }

            @Override
            public void clear() {
                AbstractChronicleMap.this.clear();
            }

            @Override
            public boolean contains(Object k) {
                return AbstractChronicleMap.this.containsKey(k);
            }

            @Override
            public void forEach(Consumer<? super K> action) {
                AbstractChronicleMap.this.forEachEntry(c -> action.accept((Object)c.key()));
            }
        };
    }

    default public boolean mapEquals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if ((m instanceof ChronicleMap ? ((ChronicleMap)m).longSize() : (long)m.size()) != this.longSize()) {
            return false;
        }
        try {
            return this.forEachEntryWhile((Predicate<? super MapKeyContext<K, V>>)((Predicate<MapKeyContext>)c -> {
                Object k = c.key();
                Object v = m.get(k instanceof CharSequence ? k.toString() : k);
                return v != null && c.valueEqualTo(v);
            }));
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    default public int mapHashCode() {
        int[] h = new int[1];
        this.forEach((k, v) -> {
            nArray[0] = h[0] + (AbstractChronicleMap.hashCode(k) ^ AbstractChronicleMap.hashCode(v));
        });
        return h[0];
    }

    public static int hashCode(Object obj) {
        if (!(obj instanceof CharSequence)) {
            return obj.hashCode();
        }
        return CharSequences.hash((CharSequence)obj);
    }

    default public String mapToString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEach((k, v) -> sb.append(k != this ? k : "(this Map)").append('=').append(v != this ? v : "(this Map)").append(',').append(' '));
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    default public Set<Map.Entry<K, V>> newEntrySet() {
        return new ChronicleMapEntrySet(this);
    }

    @Override
    default public void forEachEntry(Consumer<? super MapKeyContext<K, V>> action) {
        this.forEachEntryWhile((Predicate<? super MapKeyContext<K, V>>)((Predicate<MapKeyContext>)c -> {
            action.accept((Object)c);
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public boolean forEachEntryWhile(Predicate<? super MapKeyContext<K, V>> predicate) {
        boolean interrupt = false;
        try (VanillaContext<K, ?, ?, V, ?, ?> c = this.mapContext();){
            ForEachWhilePredicate<K, V> hashLookupPredicate = new ForEachWhilePredicate<K, V>(c, predicate);
            for (int segmentIndex = this.actualSegments() - 1; segmentIndex >= 0; --segmentIndex) {
                c.segmentIndex = segmentIndex;
                c.forEachEntry = true;
                try {
                    c.updateLock().lock();
                    if (c.size() == 0L) continue;
                    c.initSegment();
                    c.hashLookup.forEachRemoving(hashLookupPredicate);
                    if (!hashLookupPredicate.shouldBreak) continue;
                    interrupt = true;
                    break;
                }
                finally {
                    c.forEachEntry = false;
                    c.closeSegmentIndex();
                }
            }
        }
        return !interrupt;
    }

    public static class ForEachWhilePredicate<K, V>
    implements HashLookupIteration {
        private final VanillaContext<K, ?, ?, V, ?, ?> c;
        private final Predicate<? super MapKeyContext<K, V>> predicate;
        boolean shouldRemove = false;
        boolean shouldBreak = false;

        public ForEachWhilePredicate(VanillaContext<K, ?, ?, V, ?, ?> c, Predicate<? super MapKeyContext<K, V>> predicate) {
            this.c = c;
            this.predicate = predicate;
            this.shouldBreak = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(long hash, long pos) {
            this.c.pos = pos;
            this.c.initKeyFromPos();
            try {
                if (!this.c.containsKey()) {
                    this.shouldRemove = false;
                    return;
                }
                this.shouldBreak = !this.predicate.test(this.c);
                this.c.closeKey0();
                while (this.c.writeLockCount > 0) {
                    this.c.writeLock().unlock();
                }
                if (!this.c.isUpdateLocked()) {
                    throw new IllegalStateException("Shouldn't release update lock inside forEachEntry() callback");
                }
                this.shouldRemove = this.c.searchState0() == HashContext.SearchState.DELETED;
            }
            finally {
                this.c.closeKeySearch();
            }
        }

        @Override
        public boolean remove() {
            return this.shouldRemove;
        }

        @Override
        public boolean continueIteration() {
            return !this.shouldBreak;
        }
    }
}

