/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.function.SerializableFunction;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.ReaderWithSize;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.BufferResizer;
import net.openhft.chronicle.map.BytesChronicleMap;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.Work;
import net.openhft.chronicle.map.WriterWithSize;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessServerConnector<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatelessServerConnector.class.getName());
    public static final StatelessChronicleMap.EventId[] VALUES = StatelessChronicleMap.EventId.values();
    public static final int SIZE_OF_IS_EXCEPTION = 1;
    public static final int HEADER_SIZE = 13;
    @NotNull
    private final ReaderWithSize<K> keyReaderWithSize;
    @NotNull
    private final WriterWithSize<K> keyWriterWithSize;
    @NotNull
    private final ReaderWithSize<V> valueReaderWithSize;
    @NotNull
    private final WriterWithSize<V> valueWriterWithSize;
    @NotNull
    private final VanillaChronicleMap<K, ?, ?, V, ?, ?> map;
    private final BytesChronicleMap bytesMap;
    private final SerializationBuilder<K> keySerializationBuilder;
    private final SerializationBuilder<V> valueSerializationBuilder;
    private final int tcpBufferSize;

    StatelessServerConnector(@NotNull VanillaChronicleMap<K, ?, ?, V, ?, ?> map, @NotNull BufferResizer bufferResizer, int tcpBufferSize, SerializationBuilder<K> keySerializationBuilder, SerializationBuilder<V> valueSerializationBuilder) {
        this.tcpBufferSize = tcpBufferSize;
        this.keySerializationBuilder = keySerializationBuilder;
        this.valueSerializationBuilder = valueSerializationBuilder;
        this.keyReaderWithSize = new ReaderWithSize<K>(keySerializationBuilder);
        this.keyWriterWithSize = new WriterWithSize<K>(keySerializationBuilder, bufferResizer);
        this.valueReaderWithSize = new ReaderWithSize<V>(valueSerializationBuilder);
        this.valueWriterWithSize = new WriterWithSize<V>(valueSerializationBuilder, bufferResizer);
        this.map = map;
        this.bytesMap = new BytesChronicleMap(map);
    }

    @Nullable
    Work processStatelessEvent(byte eventId, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, @NotNull ByteBufferBytes reader) {
        StatelessChronicleMap.EventId event = VALUES[eventId];
        long transactionId = reader.readLong();
        long timestamp = transactionId / 10000L;
        byte identifier = reader.readByte();
        int headerSize = reader.readInt();
        reader.skip((long)headerSize);
        switch (event) {
            case KEY_SET: {
                return this.keySet((Bytes)reader, writer, transactionId);
            }
            case VALUES: {
                return this.values((Bytes)reader, writer, transactionId);
            }
            case ENTRY_SET: {
                return this.entrySet((Bytes)reader, writer, transactionId);
            }
            case PUT_WITHOUT_ACC: {
                return this.put((Bytes)reader, timestamp, identifier);
            }
            case PUT_ALL_WITHOUT_ACC: {
                return this.putAll((Bytes)reader, timestamp, identifier);
            }
            case REMOVE_WITHOUT_ACC: {
                return this.remove((Bytes)reader, timestamp, identifier);
            }
        }
        long sizeLocation = this.reflectTransactionId(writer.in(), transactionId);
        switch (event) {
            case LONG_SIZE: {
                return this.longSize(writer, sizeLocation);
            }
            case IS_EMPTY: {
                return this.isEmpty(writer, sizeLocation);
            }
            case CONTAINS_KEY: {
                return this.containsKey((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_VALUE: {
                return this.containsValue((Bytes)reader, writer, sizeLocation);
            }
            case GET: {
                return this.get((Bytes)reader, writer, sizeLocation, timestamp);
            }
            case PUT: {
                return this.put((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REMOVE: {
                return this.remove((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case CLEAR: {
                return this.clear(writer, sizeLocation, timestamp, identifier);
            }
            case REPLACE: {
                return this.replace((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REPLACE_WITH_OLD_AND_NEW_VALUE: {
                return this.replaceWithOldAndNew((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case PUT_IF_ABSENT: {
                return this.putIfAbsent((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REMOVE_WITH_VALUE: {
                return this.removeWithValue((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case TO_STRING: {
                return this.toString(writer, sizeLocation);
            }
            case APPLICATION_VERSION: {
                return this.applicationVersion(writer, sizeLocation);
            }
            case PERSISTED_DATA_VERSION: {
                return this.persistedDataVersion(writer, sizeLocation);
            }
            case PUT_ALL: {
                return this.putAll((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case HASH_CODE: {
                return this.hashCode(writer, sizeLocation);
            }
            case MAP_FOR_KEY: {
                return this.mapForKey(reader, writer, sizeLocation);
            }
            case PUT_MAPPED: {
                return this.putMapped(reader, writer, sizeLocation);
            }
            case KEY_BUILDER: {
                return this.writeBuilder(writer, sizeLocation, this.keySerializationBuilder);
            }
            case VALUE_BUILDER: {
                return this.writeBuilder(writer, sizeLocation, this.valueSerializationBuilder);
            }
        }
        throw new IllegalStateException("unsupported event=" + (Object)((Object)event));
    }

    private void writeObject(TcpReplicator.TcpSocketChannelEntryWriter writer, Object o) {
        while (true) {
            long position = writer.in().position();
            try {
                writer.in().writeObject(o);
                return;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    writer.resizeToMessage(e);
                    writer.in().position(position);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private Work writeBuilder(TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, SerializationBuilder builder) {
        try {
            this.writeObject(writer, builder);
        }
        catch (Exception e) {
            LOG.info("", (Throwable)e);
            return this.sendException(writer, sizeLocation, (Throwable)e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    public Work mapForKey(@NotNull ByteBufferBytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        Object key = this.keyReaderWithSize.read((Bytes)reader, null, null);
        SerializableFunction function = (SerializableFunction)reader.readObject();
        try {
            Object result = this.map.getMapped(key, function);
            this.writeObject(writer, result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    public Work putMapped(@NotNull ByteBufferBytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        Object key = this.keyReaderWithSize.read((Bytes)reader, null, null);
        UnaryOperator unaryOperator = (UnaryOperator)reader.readObject();
        try {
            Object result = this.map.putMapped(key, unaryOperator);
            this.writeObject(writer, result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work removeWithValue(Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        try {
            writer.ensureBufferSize(1L);
            writer.in().writeBoolean(this.bytesMap.remove(reader, reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work replaceWithOldAndNew(Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        try {
            writer.ensureBufferSize(1L);
            writer.in().writeBoolean(this.bytesMap.replace(reader, reader, reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work longSize(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        try {
            writer.in().writeLong(this.map.longSize());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work hashCode(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        try {
            writer.in().writeInt(this.map.hashCode());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work toString(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        String str;
        long remaining = writer.in().remaining();
        try {
            str = this.map.toString();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        String result = (long)str.length() < remaining ? str : str.substring(0, (int)(remaining - 4L)) + "...";
        this.writeObject(writer, result);
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work applicationVersion(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        long remaining = writer.in().remaining();
        try {
            String result = this.map.applicationVersion();
            this.writeObject(writer, result);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work persistedDataVersion(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        long remaining = writer.in().remaining();
        try {
            String result = this.map.persistedDataVersion();
            this.writeObject(writer, result);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work sendException(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, @NotNull Throwable e) {
        writer.in().position(sizeLocation + 13L);
        this.writeException(writer, e);
        this.writeSizeAndFlags(sizeLocation + 8L, true, writer.in());
        return null;
    }

    @Nullable
    private Work isEmpty(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        try {
            writer.in().writeBoolean(this.map.isEmpty());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work containsKey(Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        try {
            writer.in().writeBoolean(this.bytesMap.containsKey(reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work containsValue(Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation) {
        Object v = this.valueReaderWithSize.read(reader, null, null);
        try {
            writer.in().writeBoolean(this.map.containsValue(v));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Work get(Bytes reader, TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long transactionId) {
        this.bytesMap.output = writer;
        try {
            this.bytesMap.get(reader);
        }
        catch (Throwable e) {
            Work work = this.sendException(writer, sizeLocation, e);
            return work;
        }
        finally {
            this.bytesMap.output = null;
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work put(Bytes reader, long timestamp, byte id) {
        this.bytesMap.put(reader, reader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Work put(Bytes reader, TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        this.bytesMap.output = writer;
        try {
            this.bytesMap.put(reader, reader);
        }
        catch (Throwable e) {
            Work work = this.sendException(writer, sizeLocation, e);
            return work;
        }
        finally {
            this.bytesMap.output = null;
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work remove(Bytes reader, long timestamp, byte id) {
        this.bytesMap.remove(reader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Work remove(Bytes reader, TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        this.bytesMap.output = writer;
        try {
            this.bytesMap.remove(reader);
        }
        catch (Throwable e) {
            Work work = this.sendException(writer, sizeLocation, e);
            return work;
        }
        finally {
            this.bytesMap.output = null;
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work putAll(@NotNull Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.bytesMap.putAll(reader);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work putAll(@NotNull Bytes reader, long timestamp, byte id) {
        this.bytesMap.putAll(reader);
        return null;
    }

    @Nullable
    private Work clear(@NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.clear();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    @Nullable
    private Work values(@NotNull Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, final long transactionId) {
        Collection values;
        try {
            values = this.map.values();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = values.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(null);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if (out.position() > (long)StatelessServerConnector.this.tcpBufferSize) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, iterator.next(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    @Nullable
    private Work keySet(@NotNull Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, final long transactionId) {
        Set ks;
        try {
            ks = this.map.keySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = ks.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if (out.position() > (long)StatelessServerConnector.this.tcpBufferSize) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Object key = iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, key, keyWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    @Nullable
    private Work entrySet(@NotNull Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, final long transactionId) {
        Set<Map.Entry<K, V>> entries;
        try {
            entries = this.map.entrySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator<Map.Entry<K, V>> iterator = entries.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                if (out.position() > (long)StatelessServerConnector.this.tcpBufferSize) {
                    return false;
                }
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(copies);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if (out.position() > (long)StatelessServerConnector.this.tcpBufferSize) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Map.Entry next = (Map.Entry)iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, next.getKey(), keyWriter, copies);
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, next.getValue(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Work putIfAbsent(Bytes reader, TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        this.bytesMap.output = writer;
        try {
            this.bytesMap.putIfAbsent(reader, reader);
        }
        catch (Throwable e) {
            Work work = this.sendException(writer, sizeLocation, e);
            return work;
        }
        finally {
            this.bytesMap.output = null;
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Work replace(Bytes reader, TcpReplicator.TcpSocketChannelEntryWriter writer, long sizeLocation, long timestamp, byte id) {
        this.bytesMap.output = writer;
        try {
            this.bytesMap.replace(reader, reader);
        }
        catch (Throwable e) {
            Work work = this.sendException(writer, sizeLocation, e);
            return work;
        }
        finally {
            this.bytesMap.output = null;
        }
        this.writeSizeAndFlags(sizeLocation, false, writer.in());
        return null;
    }

    private long reflectTransactionId(@NotNull Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(4L);
        assert (transactionId != 0L);
        writer.writeLong(transactionId);
        writer.writeBoolean(false);
        return sizeLocation;
    }

    private void writeSizeAndFlags(long locationOfSize, boolean isException, @NotNull Bytes out) {
        long size = out.position() - locationOfSize;
        out.writeInt(locationOfSize, (int)size);
        out.writeBoolean(locationOfSize + 4L + 8L, isException);
        long pos = out.position();
        long limit = out.limit();
        if (LOG.isDebugEnabled()) {
            out.position(locationOfSize);
            out.limit(pos);
            LOG.info("Sending to the stateless client, bytes=" + AbstractBytes.toHex((Bytes)out) + "," + "len=" + out.remaining());
            out.limit(limit);
            out.position(pos);
        }
    }

    private void writeException(@NotNull TcpReplicator.TcpSocketChannelEntryWriter out, Throwable e) {
        this.writeObject(out, e);
    }

    @NotNull
    private Map<K, V> readEntries(@NotNull Bytes reader) {
        long numberOfEntries = reader.readStopBit();
        HashMap<K, V> result = new HashMap<K, V>();
        ThreadLocalCopies copies = this.keyReaderWithSize.getCopies(null);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(copies);
        copies = this.valueReaderWithSize.getCopies(copies);
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(copies);
        for (long i = 0L; i < numberOfEntries; ++i) {
            K key = this.keyReaderWithSize.readInLoop(reader, keyReader);
            V value = this.valueReaderWithSize.readInLoop(reader, valueReader);
            result.put(key, value);
        }
        return result;
    }

    @Nullable
    private Work sendException(@NotNull Bytes reader, @NotNull TcpReplicator.TcpSocketChannelEntryWriter writer, @NotNull Throwable e) {
        long sizeLocation = this.reflectTransactionId(writer.in(), reader.readLong());
        return this.sendException(writer, sizeLocation, e);
    }

    private long header(@NotNull Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(4L);
        writer.writeLong(transactionId);
        writer.skip(1L);
        writer.skip(1L);
        writer.skip(4L);
        return sizeLocation;
    }

    private void writeHeader(@NotNull Bytes writer, long sizeLocation, int count, boolean hasAnotherChunk) {
        long end = writer.position();
        int size = (int)(end - sizeLocation);
        writer.position(sizeLocation);
        writer.writeInt(size);
        writer.skip(8L);
        writer.writeBoolean(false);
        writer.writeBoolean(hasAnotherChunk);
        writer.writeInt(count);
        writer.position(end);
    }
}

