/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class TimeProvider
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final TimeProvider SYSTEM = new System();

    public abstract long currentTime();

    private static class System
    extends TimeProvider {
        private static final long serialVersionUID = 1L;
        private static final long SCALE = 1000L;

        private System() {
        }

        @Override
        public long currentTime() {
            return java.lang.System.currentTimeMillis() * 1000L;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private Object readResolve() throws ObjectStreamException {
            return SYSTEM;
        }
    }
}

