/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.ChronicleHashBuilderImpl;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.hashlookup.HashLookup;
import net.openhft.chronicle.hash.impl.util.BuildVersion;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.lang.Jvm;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.threadlocal.Provider;

public abstract class VanillaChronicleHash<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, C extends KeyContext<K>>
implements ChronicleHash<K, C>,
Serializable {
    private static final long serialVersionUID = 0L;
    public final String dataFileVersion = BuildVersion.version();
    public final Class<K> kClass;
    public final SizeMarshaller keySizeMarshaller;
    public final BytesReader<K> originalKeyReader;
    public final KI originalKeyInterop;
    public final MKI originalMetaKeyInterop;
    public final MetaProvider<K, KI, MKI> metaKeyInteropProvider;
    public transient Provider<BytesReader<K>> keyReaderProvider;
    transient Provider<KI> keyInteropProvider;
    public final int actualSegments;
    final HashSplitting hashSplitting;
    public final long entriesPerSegment;
    public final long chunkSize;
    public final int maxChunksPerEntry;
    public final long actualChunksPerSegment;
    final int segmentHeaderSize;
    final int segmentHashLookupValueBits;
    final int segmentHashLookupKeyBits;
    final int segmentHashLookupEntrySize;
    final long segmentHashLookupCapacity;
    final long segmentHashLookupInnerSize;
    final long segmentHashLookupOuterSize;
    final long segmentFreeListInnerSize;
    final long segmentFreeListOuterSize;
    final long segmentEntrySpaceInnerSize;
    final int segmentEntrySpaceInnerOffset;
    final long segmentEntrySpaceOuterSize;
    final long segmentSize;
    public transient BytesStore ms;
    transient Bytes bytes;
    public transient long headerSize;
    transient long segmentHeadersOffset;
    transient long segmentsOffset;

    public VanillaChronicleHash(ChronicleHashBuilderImpl<K, ?, ?> builder, boolean replicated) {
        SerializationBuilder<K> keyBuilder = builder.keyBuilder();
        this.kClass = keyBuilder.eClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.originalKeyReader = keyBuilder.reader();
        this.originalKeyInterop = keyBuilder.interop();
        this.originalMetaKeyInterop = keyBuilder.metaInterop();
        this.metaKeyInteropProvider = keyBuilder.metaInteropProvider();
        this.actualSegments = builder.actualSegments(replicated);
        this.hashSplitting = HashSplitting.Splitting.forSegments(this.actualSegments);
        this.entriesPerSegment = builder.entriesPerSegment(replicated);
        this.chunkSize = builder.chunkSize(replicated);
        this.maxChunksPerEntry = builder.maxChunksPerEntry();
        this.actualChunksPerSegment = builder.actualChunksPerSegment(replicated);
        this.segmentHeaderSize = builder.segmentHeaderSize(replicated);
        this.segmentHashLookupValueBits = HashLookup.valueBits(this.actualChunksPerSegment);
        this.segmentHashLookupKeyBits = HashLookup.keyBits(this.entriesPerSegment, this.segmentHashLookupValueBits);
        this.segmentHashLookupEntrySize = HashLookup.entrySize(this.segmentHashLookupKeyBits, this.segmentHashLookupValueBits);
        this.segmentHashLookupCapacity = HashLookup.capacityFor(this.entriesPerSegment);
        this.segmentHashLookupInnerSize = this.segmentHashLookupCapacity * (long)this.segmentHashLookupEntrySize;
        this.segmentHashLookupOuterSize = MemoryUnit.CACHE_LINES.align(this.segmentHashLookupInnerSize, MemoryUnit.BYTES);
        this.segmentFreeListInnerSize = MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
        this.segmentFreeListOuterSize = MemoryUnit.CACHE_LINES.align(this.segmentFreeListInnerSize, MemoryUnit.BYTES);
        this.segmentEntrySpaceInnerSize = this.chunkSize * this.actualChunksPerSegment;
        this.segmentEntrySpaceInnerOffset = builder.segmentEntrySpaceInnerOffset(replicated);
        this.segmentEntrySpaceOuterSize = MemoryUnit.CACHE_LINES.align((long)this.segmentEntrySpaceInnerOffset + this.segmentEntrySpaceInnerSize, MemoryUnit.BYTES);
        this.segmentSize = this.segmentSize();
    }

    private long segmentSize() {
        long ss = this.segmentHashLookupOuterSize + this.segmentFreeListOuterSize + this.segmentEntrySpaceOuterSize;
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(ss);
    }

    private long breakL1CacheAssociativityContention(long segmentSize) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(segmentSize));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            segmentSize |= MemoryUnit.CACHE_LINES.toBytes(1L);
        }
        return segmentSize;
    }

    public void initTransients() {
        this.ownInitTransients();
    }

    private void ownInitTransients() {
        this.keyReaderProvider = Provider.of(this.originalKeyReader.getClass());
        this.keyInteropProvider = Provider.of(this.originalKeyInterop.getClass());
    }

    public final void createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.bytes = this.ms.bytes();
        this.onHeaderCreated();
        this.segmentHeadersOffset = this.mapHeaderOuterSize();
        long segmentHeadersSize = this.actualSegments * this.segmentHeaderSize;
        this.segmentsOffset = this.segmentHeadersOffset + segmentHeadersSize;
    }

    public void warnOnWindows() {
        if (!Jvm.isWindows()) {
            return;
        }
        long offHeapMapSize = this.sizeInBytes();
        long oneGb = MemoryUnit.GIGABYTES.toBytes(1L);
        double offHeapMapSizeInGb = (double)offHeapMapSize * 1.0 / (double)oneGb;
        if (offHeapMapSize > MemoryUnit.GIGABYTES.toBytes(4L)) {
            System.out.printf("WARNING: On Windows, you probably cannot create a ChronicleMap\nof more than 4 GB. The configured map requires %.2f GB of off-heap memory.\n", offHeapMapSizeInGb);
        }
        try {
            long freePhysicalMemory = Jvm.freePhysicalMemoryOnWindowsInBytes();
            if ((double)offHeapMapSize > (double)freePhysicalMemory * 0.9) {
                double freePhysicalMemoryInGb = (double)freePhysicalMemory * 1.0 / (double)oneGb;
                System.out.printf("WARNING: On Windows, you probably cannot create a ChronicleMap\nof more than 90%% of available free memory in the system.\nThe configured map requires %.2f GB of off-heap memory.\nThere is only %.2f GB of free physical memory in the system.\n", offHeapMapSizeInGb, freePhysicalMemoryInGb);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void createMappedStoreAndSegments(File file) throws IOException {
        this.warnOnWindows();
        this.createMappedStoreAndSegments((BytesStore)new MappedStore(file, FileChannel.MapMode.READ_WRITE, this.sizeInBytes(), (ObjectSerializer)JDKObjectSerializer.INSTANCE));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ownInitTransients();
    }

    public void onHeaderCreated() {
    }

    public String persistedDataVersion() {
        return this.dataFileVersion;
    }

    public String applicationVersion() {
        return BuildVersion.version();
    }

    private long mapHeaderOuterSize() {
        long pageMask = (long)NativeBytes.UNSAFE.pageSize() - 1L;
        return this.mapHeaderInnerSize() + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long mapHeaderInnerSize() {
        return this.headerSize;
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    public final long sizeInBytes() {
        return this.mapHeaderOuterSize() + (long)this.actualSegments * ((long)this.segmentHeaderSize + this.segmentSize);
    }

    @Override
    public void close() {
        if (this.ms == null) {
            return;
        }
        this.bytes.release();
        this.bytes = null;
        this.ms.free();
        this.ms = null;
    }

    public final void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    public final long[] segmentSizes() {
        long[] sizes = new long[this.actualSegments];
        for (int i = 0; i < this.actualSegments; ++i) {
            sizes[i] = BigSegmentHeader.INSTANCE.size(this.ms.address() + this.segmentHeaderOffset(i));
        }
        return sizes;
    }

    public final long segmentHeaderOffset(int segmentIndex) {
        return this.segmentHeadersOffset + (long)segmentIndex * (long)this.segmentHeaderSize;
    }

    public final long segmentOffset(int segmentIndex) {
        return this.segmentsOffset + (long)segmentIndex * this.segmentSize;
    }

    public final int inChunks(long sizeInBytes) {
        if (sizeInBytes <= this.chunkSize) {
            return 1;
        }
        if (--sizeInBytes <= Integer.MAX_VALUE) {
            return (int)sizeInBytes / (int)this.chunkSize + 1;
        }
        return (int)(sizeInBytes / this.chunkSize) + 1;
    }

    @Override
    public final long longSize() {
        long result = 0L;
        for (int i = 0; i < this.actualSegments; ++i) {
            long segmentHeaderAddress = this.ms.address() + this.segmentHeaderOffset(i);
            result += BigSegmentHeader.INSTANCE.size(segmentHeaderAddress) - BigSegmentHeader.INSTANCE.deleted(segmentHeaderAddress);
        }
        return result;
    }

    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }
}

