/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesWriter;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.EngineReplicationLangBytes;
import net.openhft.chronicle.map.GetValueInterops;
import net.openhft.chronicle.map.InstanceOrBytesToInstance;
import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.ReadValue;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.SearchState;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.UpdateResult;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.CheckedBytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
extends VanillaChronicleMap<K, KI, MKI, V, VI, MVI>
implements Replica,
Replica.EntryExternalizable,
Replica.EntryResolver<K, V>,
EngineReplicationLangBytes {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    public static final int SIZE_OF_BOOTSTRAP_TIME_STAMP = 8;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    private final TimeProvider timeProvider;
    private final byte localIdentifier;
    private final AtomicReferenceArray<ModificationIterator> modificationIterators = new AtomicReferenceArray(135);
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ATSDirectBitSet modIterSet;
    private transient long startOfModificationIterators;
    private boolean bootstrapOnlyLocalEntries;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder, AbstractReplication replication) {
        super(builder);
        this.timeProvider = builder.timeProvider();
        this.localIdentifier = replication.identifier();
        this.bootstrapOnlyLocalEntries = replication.bootstrapOnlyLocalEntries();
        if (this.localIdentifier == -1) {
            throw new IllegalStateException("localIdentifier should not be -1");
        }
    }

    private static void writeTo(Bytes destination, Bytes source) {
        while (destination.remaining() > 0L && source.remaining() > 0L) {
            destination.writeByte((int)source.readByte());
        }
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(135L, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    @Override
    VanillaChronicleMap.Segment createSegment(Bytes segmentHeader, NativeBytes bytes, int index) {
        return new Segment(segmentHeader, bytes, index);
    }

    @Override
    Class segmentType() {
        return Segment.class;
    }

    @Override
    void initTransients(ChronicleMapBuilder<K, V> kvChronicleMapBuilder) {
        super.initTransients(kvChronicleMapBuilder);
        this.closeables = new CopyOnWriteArraySet<Closeable>();
    }

    long modIterBitSetSizeInBytes() {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * (long)this.segments.length);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.actualChunksPerSegment, (long)1024L);
    }

    @Override
    long getHeaderSize() {
        return super.getHeaderSize() + 1024L + this.modIterBitSetSizeInBytes() * 136L + (long)this.assignedModIterBitSetSizeInBytes();
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    void onHeaderCreated() {
        long offset = super.getHeaderSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L).zeroOut();
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modIterSet = new ATSDirectBitSet((Bytes)new CheckedBytes(modDelBytes));
    }

    private Segment segment(int segmentNum) {
        return (Segment)this.segments[segmentNum];
    }

    private long currentTime() {
        return this.timeProvider.currentTimeMillis();
    }

    @Override
    void putBytes(ThreadLocalCopies copies, VanillaChronicleMap.SegmentState segmentState, Bytes key, long keySize, VanillaChronicleMap.GetRemoteBytesValueInterops getRemoteBytesValueInterops, MultiStoreBytes value, boolean replaceIfPresent, ReadValue<Bytes> readValue) {
        this.put(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, keySize, this.keyBytesToInstance, getRemoteBytesValueInterops, value, this.valueBytesToInstance, replaceIfPresent, readValue, false, this.localIdentifier, this.currentTime());
    }

    V put(K key, V value, byte identifier, long timeStamp) {
        assert (identifier > 0);
        return this.put0(key, value, true, identifier, timeStamp);
    }

    @Override
    V put1(K key, V value, boolean replaceIfPresent) {
        return this.put0(key, value, replaceIfPresent, this.localIdentifier, this.currentTime());
    }

    V put0(K key, V value, boolean replaceIfPresent, byte identifier, long timeStamp) {
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        return (V)this.put(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, value, this.valueIdentity(), replaceIfPresent, this, this.putReturnsNull, identifier, timeStamp);
    }

    @Override
    public UpdateResult update(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long keySize = metaKeyInterop.size(keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).update(copies, null, metaKeyInterop, keyInterop, key, keySize, this.keyIdentity(), this, value, this.valueIdentity(), segmentHash, this.localIdentifier, this.currentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object remoteRemove(K key, byte remoteIdentifier, long timeStamp) {
        this.checkKey(key);
        K key1 = key;
        ThreadLocalCopies copies = VanillaChronicleMap.SegmentState.getCopies(null);
        VanillaChronicleMap.SegmentState segmentState = VanillaChronicleMap.SegmentState.get(copies);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        MetaBytesInterop metaKeyInterop = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key1);
        long keySize = metaKeyInterop.size(keyInterop, key1);
        long hash = metaKeyInterop.hash(keyInterop, key1);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        Segment segment = this.segment(segmentNum);
        segment.writeLock();
        try {
            Object object = segment.removeWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key1, keySize, this.keyIdentity(), this, null, this.valueIdentity(), segmentHash, this, this.removeReturnsNull, timeStamp, remoteIdentifier, true, false);
            return object;
        }
        finally {
            segment.writeUnlock();
        }
    }

    @Override
    <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV put2(ThreadLocalCopies copies, VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused) {
        return this.put(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, replaceIfPresent, readValue, resultUnused, this.localIdentifier, this.currentTime());
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV put(ThreadLocalCopies copies, VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused, byte identifier, long timeStamp) {
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).put(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, segmentHash, replaceIfPresent, readValue, resultUnused, identifier, timeStamp);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    public void put(Bytes key, Bytes value, byte id, long timestamp) {
        ThreadLocalCopies copies = VanillaChronicleMap.SegmentState.getCopies(null);
        VanillaChronicleMap.SegmentState segmentState = VanillaChronicleMap.SegmentState.get(copies);
        if (id == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        byte remoteIdentifier = id;
        this.setLastModificationTime(remoteIdentifier, timestamp);
        long hash = Hasher.hash(key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.localIdentifier, remoteIdentifier, key.toString().trim());
        }
        this.segment(segmentNum).remotePut(copies, segmentState, key, value, segmentHash, remoteIdentifier, timestamp);
        if (debugEnabled) {
            LOG.debug(message + "value=" + value.toString().trim() + ")");
        }
    }

    @Override
    public void remove(Bytes key, byte remoteIdentifier, long timestamp) {
        ThreadLocalCopies copies = VanillaChronicleMap.SegmentState.getCopies(null);
        VanillaChronicleMap.SegmentState segmentState = VanillaChronicleMap.SegmentState.get(copies);
        if (remoteIdentifier == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        if (remoteIdentifier == this.identifier()) {
            return;
        }
        this.setLastModificationTime(remoteIdentifier, timestamp);
        long hash = Hasher.hash(key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{this.localIdentifier, remoteIdentifier, key.toString().trim()});
        }
        this.segment(segmentNum).remoteRemove(copies, segmentState, key, segmentHash, timestamp, remoteIdentifier);
    }

    @Override
    public byte identifier() {
        return this.localIdentifier;
    }

    @Override
    public EngineReplicationLangBytes.EngineModificationIterator acquireEngineModificationIterator(byte remoteIdentifier) {
        final ModificationIterator modificationIterator = this.acquireModificationIterator(remoteIdentifier);
        return new EngineReplicationLangBytes.EngineModificationIterator(){

            @Override
            public boolean hasNext() {
                return modificationIterator.hasNext();
            }

            @Override
            public boolean nextEntry(final @NotNull EngineReplicationLangBytes.EngineEntryCallback callback) {
                return modificationIterator.nextEntry(new Replica.EntryCallback(){

                    @Override
                    public boolean onEntry(@NotNull Bytes entry, int chronicleId, long bootStrapTimeStamp) {
                        long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize(entry);
                        long keyPosition = entry.position();
                        entry.skip(keySize);
                        long timestamp = entry.readLong();
                        byte identifier = entry.readByte();
                        boolean isDeleted = entry.readBoolean();
                        if (isDeleted) {
                            return callback.onEntry((Bytes)NativeBytes.wrap((long)(entry.address() + keyPosition), (long)keySize), null, timestamp, identifier, true, bootStrapTimeStamp);
                        }
                        long valueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.readSize(entry);
                        ReplicatedChronicleMap.this.alignment.alignPositionAddr(entry);
                        long valuePosition = entry.position();
                        NativeBytes k = NativeBytes.wrap((long)(entry.address() + keyPosition), (long)keySize);
                        NativeBytes v = NativeBytes.wrap((long)(entry.address() + valuePosition), (long)valueSize);
                        return callback.onEntry((Bytes)k, (Bytes)v, timestamp, identifier, false, bootStrapTimeStamp);
                    }

                    @Override
                    public boolean shouldBeIgnored(Bytes entry, int chronicleId) {
                        return false;
                    }
                }, 0);
            }

            @Override
            public void dirtyEntries(long fromTimeStamp) {
                modificationIterator.dirtyEntries(fromTimeStamp);
            }

            @Override
            public void setModificationNotifier(final @NotNull EngineReplicationLangBytes.EngineReplicationModificationNotifier modificationNotifier) {
                modificationIterator.setModificationNotifier(new Replica.ModificationNotifier(){

                    @Override
                    public void onChange() {
                        modificationNotifier.onChange();
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModificationIterator acquireModificationIterator(byte remoteIdentifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            Bytes bytes = this.ms.bytes(this.startOfModificationIterators + this.modIterBitSetSizeInBytes() * (long)remoteIdentifier, this.modIterBitSetSizeInBytes());
            ModificationIterator newModificationIterator = new ModificationIterator(bytes);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    @Override
    void onPut(VanillaChronicleMap.Segment segment, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.acquireModificationIterator((byte)next).onPut(pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    @Override
    void onRemotePut(VanillaChronicleMap.Segment segment, long pos) {
        this.onRelocation(segment, pos);
    }

    @Override
    void onRemove(VanillaChronicleMap.Segment segment, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.acquireModificationIterator((byte)next).onRemove(pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    @Override
    void onRemoteRemove(VanillaChronicleMap.Segment segment, long pos) {
        this.onRelocation(segment, pos);
    }

    @Override
    void onRelocation(VanillaChronicleMap.Segment segment, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.acquireModificationIterator((byte)next).onRelocation(pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean identifierCheck(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            boolean bl = identifier == this.localIdentifier;
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfEntry(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                int n = 0;
                return n;
            }
            boolean isDeleted = entry.readBoolean();
            long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : 0L;
            this.alignment.alignPositionAddr(entry);
            long result = entry.position() + valueSize - start;
            assert (result < Integer.MAX_VALUE);
            int n = (int)result + 8;
            return n;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId, long bootstrapTime) {
        long initialLimit = entry.limit();
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long keyLimit = entry.position();
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        boolean isDeleted = entry.readBoolean();
        long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : 0L;
        long valuePosition = entry.position();
        destination.writeLong(bootstrapTime);
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        destination.writeByte((int)identifier);
        destination.writeBoolean(isDeleted);
        entry.position(keyPosition);
        entry.limit(keyLimit);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.limit(initialLimit);
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        entry.limit(entry.position() + valueSize);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    @Override
    public void readExternalEntry(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, @NotNull Bytes source) {
        long bootstrapTime = source.readLong();
        long keySize = this.keySizeMarshaller.readSize(source);
        long valueSize = this.valueSizeMarshaller.readSize(source);
        long timeStamp = source.readStopBit();
        byte id = source.readByte();
        boolean isDeleted = source.readBoolean();
        if (id == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        byte remoteIdentifier = id;
        if (remoteIdentifier == this.identifier()) {
            return;
        }
        this.setLastModificationTime(remoteIdentifier, bootstrapTime);
        long keyPosition = source.position();
        long keyLimit = keyPosition + keySize;
        source.limit(keyLimit);
        long hash = Hasher.hash(source);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (isDeleted) {
            if (debugEnabled) {
                LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{this.localIdentifier, remoteIdentifier, source.toString().trim()});
            }
            this.segment(segmentNum).remoteRemove(copies, segmentState, source, segmentHash, timeStamp, remoteIdentifier);
            return;
        }
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.localIdentifier, remoteIdentifier, source.toString().trim());
        }
        long valuePosition = keyLimit;
        long valueLimit = valuePosition + valueSize;
        this.segment(segmentNum).remotePut(copies, segmentState, source, keySize, valueSize, segmentHash, remoteIdentifier, timeStamp);
        if (debugEnabled) {
            source.limit(valueLimit);
            source.position(valuePosition);
            LOG.debug(message + "value=" + source.toString().trim() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K key(@NotNull Bytes entry, K usingKey) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            ThreadLocalCopies copies = this.keyReaderProvider.getCopies(null);
            Object e = ((BytesReader)this.keyReaderProvider.get(copies, (Object)this.originalKeyReader)).read(entry, keySize);
            return (K)e;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V value(@NotNull Bytes entry, V usingValue) {
        long start = entry.position();
        try {
            long valueSize;
            entry.skip(this.keySizeMarshaller.readSize(entry));
            entry.readLong();
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                V v = null;
                return v;
            }
            boolean isDeleted = entry.readBoolean();
            if (!isDeleted) {
                valueSize = this.valueSizeMarshaller.readSize(entry);
                assert (valueSize > 0L);
            } else {
                V v = null;
                return v;
            }
            this.alignment.alignPositionAddr(entry);
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, (Object)this.originalValueReader);
            V v = valueReader.read(entry, valueSize, usingValue);
            return v;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasRemoved(@NotNull Bytes entry) {
        long start = entry.position();
        try {
            boolean bl = entry.readBoolean(this.keySizeMarshaller.readSize(entry) + 9L);
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    void shouldNotBeCalledFromReplicatedChronicleMap(String method) {
        throw new AssertionError((Object)(method + "() method should not be called by " + "ReplicatedChronicleMap instance"));
    }

    class ModificationIterator
    implements Replica.ModificationIterator {
        private final ATSDirectBitSet changes;
        private final int segmentIndexShift;
        private final long posMask;
        private final net.openhft.chronicle.map.ReplicatedChronicleMap$ModificationIterator.EntryModifiableCallback entryModifiableCallback = new EntryModifiableCallback();
        private final MultiStoreBytes tmpBytes = new MultiStoreBytes();
        private Replica.ModificationNotifier modificationNotifier;
        private AtomicLong bootStrapTimeStamp = new AtomicLong();
        private long lastBootStrapTimeStamp = ReplicatedChronicleMap.access$000(ReplicatedChronicleMap.this);
        private volatile long position = -1L;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.setModificationNotifier(modificationNotifier);
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changes = new ATSDirectBitSet(bytes);
        }

        public ModificationIterator(Bytes bytes) {
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changes = new ATSDirectBitSet(bytes);
        }

        @Override
        public void setModificationNotifier(Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
        }

        private long combine(int segmentIndex, long pos) {
            return (long)segmentIndex << this.segmentIndexShift | pos;
        }

        public void onPut(long pos, SharedSegment segment) {
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.bootStrapTimeStamp.compareAndSet(0L, this.timestamp(pos, segment));
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        private long timestamp(long pos, SharedSegment segment) {
            long timeStamp = segment.timeStamp(pos);
            return timeStamp;
        }

        public void onRemove(long pos, SharedSegment segment) {
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.bootStrapTimeStamp.compareAndSet(0L, this.timestamp(pos, segment));
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        void onRelocation(long pos, SharedSegment segment) {
            this.changes.clear(this.combine(segment.getIndex(), pos));
        }

        @Override
        public boolean hasNext() {
            long position = this.position;
            return this.changes.nextSetBit(position + 1L) != -1L || position >= 0L && this.changes.nextSetBit(0L) != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changes.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition == -1L) {
                        this.position = -1L;
                        return false;
                    }
                    this.bootStrapTimeStamp.set(0L);
                    continue;
                }
                this.position = position;
                Segment segment = ReplicatedChronicleMap.this.segment((int)(position >>> this.segmentIndexShift));
                segment.readLock(null);
                try {
                    if (!this.changes.get(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    MultiStoreBytes entry = segment.reuse(this.tmpBytes, segment.offsetFromPos(segmentPos));
                    boolean success = entryCallback.onEntry((Bytes)entry, chronicleId, this.bootStrapTimeStamp());
                    entryCallback.onAfterEntry();
                    if (success) {
                        this.changes.clear(position);
                    }
                    boolean bl = success;
                    return bl;
                }
                finally {
                    segment.readUnlock();
                    continue;
                }
                break;
            }
        }

        private long bootStrapTimeStamp() {
            long result;
            long timeStamp = this.bootStrapTimeStamp.get();
            this.lastBootStrapTimeStamp = result = timeStamp == 0L ? this.lastBootStrapTimeStamp : timeStamp;
            return result;
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            for (Segment segment : (Segment[])ReplicatedChronicleMap.this.segments) {
                segment.dirtyEntries(fromTimeStamp, (EntryModifiableCallback)this.entryModifiableCallback, ReplicatedChronicleMap.this.bootstrapOnlyLocalEntries);
            }
        }

        class EntryModifiableCallback {
            EntryModifiableCallback() {
            }

            public void set(int segmentIndex, long pos) {
                long combine = ModificationIterator.this.combine(segmentIndex, pos);
                ModificationIterator.this.changes.set(combine);
            }
        }
    }

    class TimestampTrackingEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 0L;
        transient long timestamp;

        public TimestampTrackingEntry(K key, V value, long timestamp) {
            super(key, value);
            this.timestamp = timestamp;
        }

        @Override
        public V setValue(V value) {
            long newTimestamp = this.timestamp = ReplicatedChronicleMap.this.currentTime();
            ReplicatedChronicleMap.this.put(this.getKey(), value, ReplicatedChronicleMap.this.localIdentifier, newTimestamp);
            return super.setValue(value);
        }
    }

    class Segment
    extends VanillaChronicleMap.Segment {
        final MultiStoreBytes timestampBytes;

        Segment(Bytes segmentHeader, NativeBytes bytes, int index) {
            super(ReplicatedChronicleMap.this, segmentHeader, bytes, index);
            this.timestampBytes = new MultiStoreBytes();
        }

        @Override
        long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
            return super.sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
        }

        @Override
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV> RV acquireWithoutLock(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, ReadValue<RV> readValue, RV usingValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, boolean create, VanillaChronicleMap.MutableLockedEntry lock) {
            long pos;
            MultiStoreBytes entry = segmentState.tmpBytes;
            MultiMap hashLookup = this.hashLookup();
            SearchState searchState = segmentState.searchState;
            hashLookup.startSearch(hash2, searchState);
            while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                entry.skip(9L);
                boolean isDeleted = entry.readBoolean();
                if (isDeleted) {
                    MetaBytesWriter metaElemWriter;
                    Object elemWriter;
                    Object elem;
                    long timestamp;
                    if (!create) {
                        return readValue.readNull();
                    }
                    long valueSizePos = entry.position();
                    entry.position(valueSizePos - 10L);
                    segmentState.timestamp = timestamp = ReplicatedChronicleMap.this.currentTime();
                    long replacedTimestamp = entry.readLong(entry.position());
                    entry.writeLong(timestamp);
                    byte replacedIdentifier = entry.readByte(entry.position());
                    entry.writeByte((int)ReplicatedChronicleMap.this.localIdentifier);
                    entry.writeBoolean(false);
                    long prevValueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
                    long sizeOfEverythingBeforeValue = entry.position();
                    ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
                    long valueAddr = entry.positionAddr();
                    long entryEndAddr = valueAddr + prevValueSize;
                    Object keyInstance = toKey.toInstance(copies, key, keySize);
                    if (ReplicatedChronicleMap.this.defaultValueProvider != null) {
                        Object valueInterop;
                        Object defaultValue = ReplicatedChronicleMap.this.defaultValueProvider.get(keyInstance);
                        elem = defaultValue;
                        elemWriter = valueInterop = ReplicatedChronicleMap.this.valueInteropProvider.get(copies, ReplicatedChronicleMap.this.originalValueInterop);
                        metaElemWriter = ReplicatedChronicleMap.this.metaValueInteropProvider.get(copies, ReplicatedChronicleMap.this.originalMetaValueInterop, valueInterop, defaultValue);
                    } else if (ReplicatedChronicleMap.this.prepareValueBytesAsWriter != null) {
                        elem = keyInstance;
                        elemWriter = null;
                        metaElemWriter = ReplicatedChronicleMap.this.prepareValueBytesAsWriter;
                    } else {
                        throw this.defaultValueOrPrepareBytesShouldBeSpecified();
                    }
                    long elemSize = metaElemWriter.size(elemWriter, elem);
                    this.putValue(pos, entry, valueSizePos, entryEndAddr, isDeleted, segmentState, metaElemWriter, elemWriter, elem, elemSize, hashLookup, sizeOfEverythingBeforeValue);
                    pos = segmentState.pos;
                    this.incrementSize();
                    hashLookup.putPosition(pos);
                    entry.position(valueSizePos);
                    long valueSize = ReplicatedChronicleMap.this.readValueSize((Bytes)entry);
                    assert (valueSize == elemSize);
                    long valuePos = entry.position();
                    RV v = readValue.readValue(copies, (Bytes)entry, usingValue, valueSize);
                    ReplicatedChronicleMap.this.onPut(this, pos);
                    if (ReplicatedChronicleMap.this.bytesEventListener != null) {
                        ReplicatedChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, ReplicatedChronicleMap.this.metaDataBytes, valuePos, true, false, true, ReplicatedChronicleMap.this.localIdentifier, replacedIdentifier, timestamp, replacedTimestamp);
                    }
                    if (ReplicatedChronicleMap.this.eventListener != null) {
                        Object valueInstance = toValue.toInstance(copies, v, valueSize);
                        ReplicatedChronicleMap.this.eventListener.onPut(keyInstance, valueInstance, null, false, true, true, ReplicatedChronicleMap.this.localIdentifier, replacedIdentifier, timestamp, replacedTimestamp);
                    }
                    this.entryCreated(lock);
                    return v;
                }
                segmentState.pos = pos;
                return this.readValueAndNotifyGet(copies, key, keySize, toKey, readValue, usingValue, toValue, entry);
            }
            if (!create) {
                return readValue.readNull();
            }
            RV result = this.createEntryOnAcquire(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, readValue, usingValue, toValue, entry);
            this.entryCreated(lock);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remoteRemove(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, Bytes keyBytes, long hash2, long timestamp, byte identifier) {
            this.writeLock();
            try {
                VanillaChronicleMap.ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
                readValueToLazyBytes.valueSizeMarshaller(ReplicatedChronicleMap.this.valueSizeMarshaller);
                Boolean removed = (Boolean)this.removeWithoutLock(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, keyBytes, keyBytes.remaining(), ReplicatedChronicleMap.this.keyBytesToInstance, null, null, ReplicatedChronicleMap.this.outputValueBytesToInstance, hash2, readValueToLazyBytes, true, timestamp, identifier, true, true);
                if (!removed.booleanValue() && LOG.isDebugEnabled()) {
                    LOG.debug("Segment.remoteRemove() : key=" + keyBytes.toString().trim() + " was not found (or the remote update is late)");
                }
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remotePut(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, @NotNull Bytes entry, long keySize, long valueSize, long hash2, byte identifier, long timestamp) {
            VanillaChronicleMap.GetRemoteBytesValueInterops getRemoteBytesValueInterops = segmentState.getRemoteBytesValueInterops;
            MultiStoreBytes value = getRemoteBytesValueInterops.getValueBytes(entry, entry.position() + keySize);
            getRemoteBytesValueInterops.valueSize(valueSize);
            VanillaChronicleMap.ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
            readValueToLazyBytes.valueSizeMarshaller(ReplicatedChronicleMap.this.valueSizeMarshaller);
            this.writeLock();
            try {
                this.putWithoutLock(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, entry, keySize, ReplicatedChronicleMap.this.keyBytesToInstance, getRemoteBytesValueInterops, value, ReplicatedChronicleMap.this.valueBytesToInstance, hash2, true, readValueToLazyBytes, true, identifier, timestamp, true);
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remotePut(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, @NotNull Bytes key, @NotNull Bytes value, long hash2, byte identifier, long timestamp) {
            VanillaChronicleMap.ReadValueToBytes readValueToLazyBytes = segmentState.readValueToLazyBytes;
            readValueToLazyBytes.valueSizeMarshaller(ReplicatedChronicleMap.this.valueSizeMarshaller);
            this.writeLock();
            try {
                this.putWithoutLock(copies, segmentState, DelegatingMetaBytesInterop.instance(), BytesBytesInterop.INSTANCE, key, key.remaining(), ReplicatedChronicleMap.this.keyBytesToInstance, VanillaChronicleMap.GetRemoteSeparateBytesInterops.INSTANCE, value, ReplicatedChronicleMap.this.valueBytesToInstance, hash2, true, readValueToLazyBytes, true, identifier, timestamp, true);
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV put(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused, byte identifier, long timeStamp) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = VanillaChronicleMap.SegmentState.getCopies(copies);
                segmentState = VanillaChronicleMap.SegmentState.get(copies);
            }
            this.writeLock();
            segmentState.identifier = identifier;
            segmentState.timestamp = timeStamp;
            try {
                RV RV = this.putWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, hash2, replaceIfPresent, readValue, resultUnused, identifier, timeStamp, false);
                return RV;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> UpdateResult update(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, byte identifier, long timeStamp) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = VanillaChronicleMap.SegmentState.getCopies(copies);
                segmentState = VanillaChronicleMap.SegmentState.get(copies);
            }
            this.writeLock();
            segmentState.identifier = identifier;
            segmentState.timestamp = timeStamp;
            try {
                long replacedTimestamp;
                byte replacedIdentifier;
                long pos;
                MultiMap hashLookup = this.hashLookup();
                SearchState searchState = segmentState.searchState;
                hashLookup.startSearch(hash2, searchState);
                MultiStoreBytes entry = segmentState.tmpBytes;
                while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                    UpdateResult updateResult;
                    long offset = this.offsetFromPos(pos);
                    this.reuse(entry, offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timeStampPosAddr = entry.positionAddr();
                    if (this.shouldIgnore((Bytes)entry, timeStamp, identifier)) {
                        throw new IllegalStateException();
                    }
                    boolean isDeleted = entry.readBoolean();
                    entry.positionAddr(timeStampPosAddr);
                    long replacedTimestamp2 = entry.readLong(entry.position());
                    entry.writeLong(timeStamp);
                    byte replacedIdentifier2 = entry.readByte(entry.position());
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(false);
                    VBI valueInterop = getValueInterops.getValueInterop(copies);
                    MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, value);
                    long valueSize = metaValueInterop.size(valueInterop, value);
                    long valueSizePos = entry.position();
                    long prevValueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
                    long sizeOfEverythingBeforeValue = entry.position();
                    ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
                    if (!isDeleted && prevValueSize == valueSize && metaValueInterop.startsWith(valueInterop, (Bytes)entry, value)) {
                        updateResult = UpdateResult.UNCHANGED;
                    } else {
                        long valueAddr = entry.positionAddr();
                        long entryEndAddr = valueAddr + prevValueSize;
                        this.putValue(pos, entry, valueSizePos, entryEndAddr, isDeleted, segmentState, metaValueInterop, valueInterop, value, valueSize, hashLookup, sizeOfEverythingBeforeValue);
                        updateResult = isDeleted ? UpdateResult.INSERT : UpdateResult.UPDATE;
                    }
                    boolean hasValueChanged = updateResult != UpdateResult.UNCHANGED;
                    this.onPutMaybeRemote(segmentState.pos, false);
                    if (ReplicatedChronicleMap.this.bytesEventListener != null) {
                        ReplicatedChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, ReplicatedChronicleMap.this.metaDataBytes, valueSizePos, false, false, hasValueChanged, identifier, replacedIdentifier2, timeStamp, replacedTimestamp2);
                    }
                    if (ReplicatedChronicleMap.this.eventListener != null) {
                        ReplicatedChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, value, valueSize), null, false, isDeleted, hasValueChanged, identifier, replacedIdentifier2, timeStamp, replacedTimestamp2);
                    }
                    if (isDeleted) {
                        this.incrementSize();
                        if (pos == segmentState.pos) {
                            hashLookup.putPosition(segmentState.pos);
                        } else assert (hashLookup.getPositions().isSet(segmentState.pos));
                    }
                    UpdateResult updateResult2 = updateResult;
                    return updateResult2;
                }
                VBI valueInterop = getValueInterops.getValueInterop(copies);
                MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, value);
                long valueSize = metaValueInterop.size(valueInterop, value);
                this.putEntry(segmentState, metaKeyInterop, keyInterop, key, keySize, metaValueInterop, valueInterop, value, entry, false);
                entry.position(segmentState.valueSizePos - 10L);
                entry.writeLong(timeStamp);
                entry.writeByte((int)identifier);
                entry.writeBoolean(false);
                this.onPutMaybeRemote(segmentState.pos, false);
                if (ReplicatedChronicleMap.this.bytesEventListener != null) {
                    replacedIdentifier = 0;
                    replacedTimestamp = 0L;
                    ReplicatedChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, ReplicatedChronicleMap.this.metaDataBytes, segmentState.valueSizePos, true, false, true, identifier, replacedIdentifier, timeStamp, replacedTimestamp);
                }
                if (ReplicatedChronicleMap.this.eventListener != null) {
                    replacedIdentifier = 0;
                    replacedTimestamp = 0L;
                    ReplicatedChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, value, valueSize), null, false, true, true, identifier, replacedIdentifier, timeStamp, replacedTimestamp);
                }
                UpdateResult updateResult = UpdateResult.INSERT;
                return updateResult;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        @Override
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV putWithoutLock(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused) {
            return this.putWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, value, toValue, hash2, replaceIfPresent, readValue, resultUnused, ReplicatedChronicleMap.this.localIdentifier, ReplicatedChronicleMap.this.currentTime(), false);
        }

        private <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> RV putWithoutLock(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB value, InstanceOrBytesToInstance<? super VB, V> toValue, long hash2, boolean replaceIfPresent, ReadValue<RV> readValue, boolean resultUnused, byte identifier, long timestamp, boolean remote) {
            long replacedTimestamp;
            byte replacedIdentifier;
            long pos;
            segmentState.identifier = identifier;
            segmentState.timestamp = timestamp;
            MultiMap hashLookup = this.hashLookup();
            SearchState searchState = segmentState.searchState;
            hashLookup.startSearch(hash2, searchState);
            MultiStoreBytes entry = segmentState.tmpBytes;
            while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                long timeStampPosAddr = entry.positionAddr();
                if (this.shouldIgnore((Bytes)entry, timestamp, identifier)) {
                    return null;
                }
                boolean isDeleted = entry.readBoolean();
                if (replaceIfPresent || isDeleted) {
                    entry.positionAddr(timeStampPosAddr);
                    long replacedTimestamp2 = entry.readLong(entry.position());
                    entry.writeLong(timestamp);
                    byte replacedIdentifier2 = entry.readByte(entry.position());
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(false);
                    RV prevValue = this.replaceValueAndNotifyPut(copies, segmentState, key, keySize, toKey, getValueInterops, value, toValue, entry, pos, hashLookup, readValue, resultUnused, isDeleted, remote, replacedIdentifier2, replacedTimestamp2);
                    if (isDeleted) {
                        this.incrementSize();
                        if (pos == segmentState.pos) {
                            hashLookup.putPosition(segmentState.pos);
                        } else assert (hashLookup.getPositions().isSet(segmentState.pos));
                    }
                    if (resultUnused) {
                        return null;
                    }
                    return isDeleted ? readValue.readNull() : prevValue;
                }
                long valueSize = ReplicatedChronicleMap.this.readValueSize((Bytes)entry);
                return resultUnused ? null : readValue.readValue(copies, (Bytes)entry, null, valueSize);
            }
            VBI valueInterop = getValueInterops.getValueInterop(copies);
            MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, value);
            long valueSize = metaValueInterop.size(valueInterop, value);
            this.putEntry(segmentState, metaKeyInterop, keyInterop, key, keySize, metaValueInterop, valueInterop, value, entry, false);
            entry.position(segmentState.valueSizePos - 10L);
            entry.writeLong(timestamp);
            entry.writeByte((int)identifier);
            entry.writeBoolean(false);
            this.onPutMaybeRemote(segmentState.pos, remote);
            if (ReplicatedChronicleMap.this.bytesEventListener != null) {
                replacedIdentifier = 0;
                replacedTimestamp = 0L;
                ReplicatedChronicleMap.this.bytesEventListener.onPut((Bytes)entry, 0L, ReplicatedChronicleMap.this.metaDataBytes, segmentState.valueSizePos, true, remote, true, identifier, replacedIdentifier, timestamp, replacedTimestamp);
            }
            if (ReplicatedChronicleMap.this.eventListener != null) {
                replacedIdentifier = 0;
                replacedTimestamp = 0L;
                ReplicatedChronicleMap.this.eventListener.onPut(toKey.toInstance(copies, key, keySize), toValue.toInstance(copies, value, valueSize), null, remote, true, true, identifier, replacedIdentifier, timestamp, replacedTimestamp);
            }
            return resultUnused ? null : (RV)readValue.readNull();
        }

        private boolean shouldIgnore(@NotNull Bytes entry, long timestamp, byte identifier) {
            long lastModifiedTimeStamp = entry.readLong();
            if (lastModifiedTimeStamp < timestamp) {
                entry.skip(1L);
                return false;
            }
            if (lastModifiedTimeStamp > timestamp) {
                return true;
            }
            return entry.readByte() > identifier;
        }

        @Override
        void manageReplicationBytes(VanillaChronicleMap.SegmentState segmentState, Bytes entry, boolean writeDefaultInitialReplicationValues, boolean remove) {
            if (!writeDefaultInitialReplicationValues) {
                entry.skip(10L);
            } else {
                segmentState.timestamp = ReplicatedChronicleMap.this.currentTime();
                entry.writeLong(segmentState.timestamp);
                entry.writeByte((int)ReplicatedChronicleMap.this.localIdentifier);
                entry.writeBoolean(remove);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object remove(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, ReadValue<RV> readValue, boolean resultUnused) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = VanillaChronicleMap.SegmentState.getCopies(copies);
                segmentState = VanillaChronicleMap.SegmentState.get(copies);
            }
            this.writeLock();
            try {
                Object object = this.removeWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, expectedValue, toValue, hash2, readValue, resultUnused, ReplicatedChronicleMap.this.currentTime(), ReplicatedChronicleMap.this.localIdentifier, false, expectedValue != null);
                return object;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        @Override
        boolean isDeleted(Bytes entry, long keySize) {
            return entry.readBoolean(entry.position() + keySize + 10L - 1L);
        }

        @Override
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object removeWithoutLock(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, ReadValue<RV> readValue, boolean resultUnused) {
            return this.removeWithoutLock(copies, segmentState, metaKeyInterop, keyInterop, key, keySize, toKey, getValueInterops, expectedValue, toValue, hash2, readValue, resultUnused, ReplicatedChronicleMap.this.currentTime(), ReplicatedChronicleMap.this.localIdentifier, false, expectedValue != null);
        }

        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<? super VB, ? super VBI>> Object removeWithoutLock(@NotNull ThreadLocalCopies copies, @NotNull VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getValueInterops, VB expectedValue, InstanceOrBytesToInstance<RV, V> toValue, long hash2, ReadValue<RV> readValue, boolean resultUnused, long timestamp, byte identifier, boolean remote, boolean booleanResult) {
            block10: {
                long pos;
                segmentState.identifier = identifier;
                segmentState.timestamp = timestamp;
                assert (identifier > 0);
                VanillaChronicleMap.expectedValueNotNullImpliesBooleanResult(expectedValue, booleanResult);
                MultiMap hashLookup = this.hashLookup();
                SearchState searchState = segmentState.searchState;
                hashLookup.startSearch(hash2, searchState);
                MultiStoreBytes entry = segmentState.tmpBytes;
                while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                    long offset = this.offsetFromPos(pos);
                    this.reuse(entry, offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timestampPos = entry.position();
                    long replacedTimestamp = entry.readLong(timestampPos);
                    byte replacedIdentifier = entry.readByte(timestampPos + 8L);
                    if (this.shouldIgnore((Bytes)entry, timestamp, identifier)) {
                        return booleanResult ? Boolean.FALSE : null;
                    }
                    boolean isDeleted = entry.readBoolean();
                    if (isDeleted) {
                        if (expectedValue != null) {
                            return Boolean.FALSE;
                        }
                        entry.position(timestampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                        this.onRemoveMaybeRemote(pos, remote);
                        break block10;
                    }
                    long valueSizePos = entry.position();
                    long valueSize = ReplicatedChronicleMap.this.readValueSize((Bytes)entry);
                    long valuePos = entry.position();
                    if (expectedValue != null) {
                        VBI valueInterop = getValueInterops.getValueInterop(copies);
                        MVBI metaValueInterop = getValueInterops.getMetaValueInterop(copies, valueInterop, expectedValue);
                        if (metaValueInterop.size(valueInterop, expectedValue) != valueSize) {
                            return Boolean.FALSE;
                        }
                        if (!metaValueInterop.startsWith(valueInterop, (Bytes)entry, expectedValue)) {
                            return Boolean.FALSE;
                        }
                    }
                    entry.position(timestampPos);
                    entry.writeLong(timestamp);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                    entry.position(valuePos);
                    return this.removeEntry(copies, segmentState, key, keySize, toKey, toValue, readValue, resultUnused, hashLookup, entry, pos, valueSizePos, valueSize, remote, false, booleanResult, replacedIdentifier, replacedTimestamp);
                }
                if (remote) {
                    long minEncodableValueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.minEncodableSize();
                    long entrySize = this.entrySize(keySize, minEncodableValueSize);
                    int allocatedChunks = this.inChunks(entrySize);
                    long pos2 = this.alloc(allocatedChunks);
                    long offset = this.offsetFromPos(pos2);
                    this.clearMetaData(offset);
                    this.reuse(entry, offset);
                    ReplicatedChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
                    metaKeyInterop.write(keyInterop, (Bytes)entry, key);
                    entry.writeLong(timestamp);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                    ReplicatedChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, minEncodableValueSize);
                    ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
                    entry.skip(minEncodableValueSize);
                    this.freeExtraAllocatedChunks(pos2, allocatedChunks, (Bytes)entry);
                    hashLookup.putAfterFailedSearch(searchState, pos2);
                    hashLookup.removePosition(pos2);
                }
            }
            if (booleanResult) {
                return Boolean.FALSE;
            }
            return resultUnused ? null : readValue.readNull();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        <KB, KBI, MKBI extends MetaBytesInterop<KB, ? super KBI>, RV, VB extends RV, VBI, MVBI extends MetaBytesInterop<RV, ? super VBI>> Object replace(@Nullable ThreadLocalCopies copies, @Nullable VanillaChronicleMap.SegmentState segmentState, MKBI metaKeyInterop, KBI keyInterop, KB key, long keySize, InstanceOrBytesToInstance<KB, K> toKey, GetValueInterops<VB, VBI, MVBI> getExpectedValueInterops, VB expectedValue, GetValueInterops<VB, VBI, MVBI> getNewValueInterops, VB newValue, ReadValue<RV> readValue, InstanceOrBytesToInstance<? super RV, V> toValue, long hash2) {
            VanillaChronicleMap.segmentStateNotNullImpliesCopiesNotNull(copies, segmentState);
            if (segmentState == null) {
                copies = VanillaChronicleMap.SegmentState.getCopies(copies);
                segmentState = VanillaChronicleMap.SegmentState.get(copies);
            }
            long timestamp = ReplicatedChronicleMap.this.currentTime();
            byte identifier = ReplicatedChronicleMap.this.localIdentifier;
            this.writeLock();
            segmentState.identifier = identifier;
            segmentState.timestamp = timestamp;
            try {
                long pos;
                MultiMap hashLookup = this.hashLookup();
                SearchState searchState = segmentState.searchState;
                hashLookup.startSearch(hash2, searchState);
                MultiStoreBytes entry = segmentState.tmpBytes;
                while ((pos = hashLookup.nextPos(searchState)) >= 0L) {
                    long offset = this.offsetFromPos(pos);
                    this.reuse(entry, offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timestampPos = entry.position();
                    long replacedTimestamp = entry.readLong();
                    byte replacedIdentifier = entry.readByte();
                    entry.position(timestampPos);
                    if (this.shouldIgnore((Bytes)entry, timestamp, identifier)) {
                        LOG.error("Trying to replace a value for key={} on the node with id={} at time={} (current time), but the entry is updated by node with id={} at time={}. Time is not monotonic across nodes!?", new Object[]{key, identifier, timestamp, entry.readByte(entry.position() - 1L), entry.readLong(entry.position() - 10L + 1L)});
                        RV RV = readValue.readNull();
                        return RV;
                    }
                    boolean isDeleted = entry.readBoolean();
                    if (isDeleted) break;
                    Object result = this.onKeyPresentOnReplace(copies, segmentState, key, keySize, toKey, getExpectedValueInterops, expectedValue, getNewValueInterops, newValue, readValue, toValue, pos, entry, hashLookup, replacedIdentifier, replacedTimestamp);
                    if (result != Boolean.FALSE) {
                        entry.position(timestampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                    }
                    Object object = result;
                    return object;
                }
                Boolean bl = expectedValue == null ? readValue.readNull() : Boolean.FALSE;
                return bl;
            }
            finally {
                segmentState.close();
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dirtyEntries(final long timeStamp, final ModificationIterator.EntryModifiableCallback callback, final boolean bootstrapOnlyLocalEntries) {
            this.readLock(null);
            ThreadLocalCopies copies = VanillaChronicleMap.SegmentState.getCopies(null);
            try (VanillaChronicleMap.SegmentState segmentState = VanillaChronicleMap.SegmentState.get(copies);){
                final int index = this.getIndex();
                final MultiStoreBytes tmpBytes = segmentState.tmpBytes;
                this.hashLookup().forEach(new MultiMap.EntryConsumer(){

                    @Override
                    public void accept(long hash, long pos) {
                        MultiStoreBytes entry = Segment.this.reuse(tmpBytes, Segment.this.offsetFromPos(pos));
                        long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
                        entry.skip(keySize);
                        long entryTimestamp = entry.readLong();
                        if (!(entryTimestamp < timeStamp || bootstrapOnlyLocalEntries && entry.readByte() != ReplicatedChronicleMap.this.identifier())) {
                            callback.set(index, pos);
                        }
                    }
                });
            }
            finally {
                this.readUnlock();
            }
        }

        @Override
        public Map.Entry<K, V> getEntry(@NotNull VanillaChronicleMap.SegmentState segmentState, long pos) {
            MultiStoreBytes entry = this.reuse(segmentState.tmpBytes, this.offsetFromPos(pos));
            long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            ThreadLocalCopies copies = ReplicatedChronicleMap.this.keyReaderProvider.getCopies(null);
            Object key = ((BytesReader)ReplicatedChronicleMap.this.keyReaderProvider.get(copies, (Object)ReplicatedChronicleMap.this.originalKeyReader)).read((Bytes)entry, keySize);
            long timestamp = entry.readLong();
            entry.skip(2L);
            long valueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
            ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            copies = ReplicatedChronicleMap.this.valueReaderProvider.getCopies(copies);
            Object value = ((BytesReader)ReplicatedChronicleMap.this.valueReaderProvider.get(copies, (Object)ReplicatedChronicleMap.this.originalValueReader)).read((Bytes)entry, valueSize);
            return new TimestampTrackingEntry(key, value, timestamp);
        }

        @Override
        public long timeStamp(long pos) {
            MultiStoreBytes entry = this.reuse(this.timestampBytes, this.offsetFromPos(pos));
            long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            entry.skip(keySize);
            return entry.readLong();
        }
    }
}

