/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.nio.ByteBuffer;
import net.openhft.chronicle.hash.hashing.Accesses;
import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.Nullable;

public enum ByteBufferMarshaller implements BytesInterop<ByteBuffer>,
BytesReader<ByteBuffer>
{
    INSTANCE;


    @Override
    public boolean startsWith(Bytes bytes, ByteBuffer bb) {
        int i;
        int inputRemaining = bb.remaining();
        if (bytes.capacity() - bytes.position() < (long)inputRemaining) {
            return false;
        }
        long pos = bytes.position();
        int inputPos = bb.position();
        for (i = 0; i < inputRemaining - 7; i += 8) {
            if (bytes.readLong(pos + (long)i) == bb.getLong(inputPos + i)) continue;
            return false;
        }
        while (i < inputRemaining - 3) {
            if (bytes.readInt(pos + (long)i) != bb.getInt(inputPos + i)) {
                return false;
            }
            i += 4;
        }
        while (i < inputRemaining) {
            if (bytes.readByte(pos + (long)i) != bb.get(inputPos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public long hash(ByteBuffer bb) {
        return Hasher.hash(bb, Accesses.toByteBuffer(), 0L, bb.remaining());
    }

    @Override
    public ByteBuffer read(Bytes bytes, long size) {
        return this.read(bytes, size, null);
    }

    @Override
    public ByteBuffer read(Bytes bytes, long size, @Nullable ByteBuffer toReuse) {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ByteBuffer size should be non-negative int, " + size + " given. Memory corruption?");
        }
        int intSize = (int)size;
        if (toReuse == null || toReuse.capacity() < intSize) {
            toReuse = ByteBuffer.allocate(intSize);
        } else {
            toReuse.position(0);
            toReuse.limit(intSize);
        }
        bytes.read(toReuse);
        toReuse.flip();
        return toReuse;
    }

    @Override
    public long size(ByteBuffer bb) {
        return bb.remaining();
    }

    @Override
    public void write(Bytes bytes, ByteBuffer bb) {
        int position = bb.position();
        bytes.write(bb);
        bb.position(position);
    }
}

