/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.EntryReader;
import net.openhft.chronicle.map.EntryWriter;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.UdpChannelReplicator;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UdpReplicator
extends UdpChannelReplicator
implements Replica.ModificationNotifier,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)UdpReplicator.class.getName());
    public static final int UPD_BUFFER_SIZE = 77056;

    public UdpReplicator(@NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, @NotNull UdpTransportConfig replicationConfig) throws IOException {
        super(replicationConfig, replica.identifier());
        Replica.ModificationIterator modificationIterator = replica.acquireModificationIterator((byte)127);
        modificationIterator.setModificationNotifier(this);
        this.setReader(new UdpSocketChannelEntryReader(replicationConfig.udpBufferSize(), entryExternalizable));
        this.setWriter(new UdpSocketChannelEntryWriter(replicationConfig.udpBufferSize(), entryExternalizable, modificationIterator, this, new Replicators.OutBuffer(77056)));
        this.start();
    }

    private static class UdpSocketChannelEntryWriter
    implements EntryWriter {
        private final AbstractChannelReplicator.EntryCallback entryCallback;
        private final UdpChannelReplicator udpReplicator;
        private final Replicators.OutBuffer outBuffer;
        private Replica.ModificationIterator modificationIterator;

        UdpSocketChannelEntryWriter(int updBufferSize, @NotNull Replica.EntryExternalizable externalizable, @NotNull Replica.ModificationIterator modificationIterator, UdpChannelReplicator udpReplicator, Replicators.OutBuffer outBuffer) {
            this.udpReplicator = udpReplicator;
            this.outBuffer = outBuffer;
            this.entryCallback = new AbstractChannelReplicator.EntryCallback(externalizable, updBufferSize);
            this.modificationIterator = modificationIterator;
        }

        @Override
        public int writeAll(@NotNull DatagramChannel socketChannel) throws InterruptedException, IOException {
            ByteBufferBytes in = this.outBuffer.in();
            ByteBuffer out = this.outBuffer.out();
            out.clear();
            in.clear();
            in.skip(4L);
            boolean wasDataRead = this.modificationIterator.nextEntry(this.entryCallback, 0);
            if (!wasDataRead) {
                this.udpReplicator.disableWrites();
                return 0;
            }
            in.writeShort(0L, ~in.readUnsignedShort(4L));
            out.limit((int)in.position());
            return socketChannel.write(out);
        }
    }

    private class UdpSocketChannelEntryReader
    implements EntryReader {
        private final Replica.EntryExternalizable externalizable;
        private final ByteBuffer in;
        private final ByteBufferBytes out;

        UdpSocketChannelEntryReader(@NotNull int serializedEntrySize, Replica.EntryExternalizable externalizable) {
            this.in = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.externalizable = externalizable;
            this.out = new ByteBufferBytes(this.in);
            this.out.limit(0L);
            this.in.clear();
        }

        @Override
        public void readAll(@NotNull DatagramChannel socketChannel) throws IOException, InterruptedException {
            this.out.clear();
            this.in.clear();
            socketChannel.receive(this.in);
            int bytesRead = this.in.position();
            if (bytesRead < 8) {
                return;
            }
            this.out.limit((long)this.in.position());
            int invertedSize = this.out.readInt();
            int size = this.out.readInt();
            if (~size != invertedSize) {
                return;
            }
            if (this.out.remaining() != (long)size) {
                return;
            }
            this.externalizable.readExternalEntry(UdpReplicator.this.copies, UdpReplicator.this.segmentState, (Bytes)this.out);
        }
    }
}

