/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import java.net.InetAddress;
import java.net.NetworkInterface;
import net.openhft.chronicle.hash.ReplicationConfig;
import net.openhft.chronicle.hash.ThrottlingConfig;
import net.openhft.chronicle.hash.UdpReplicationConfigBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UdpReplicationConfig
implements ReplicationConfig {
    UdpReplicationConfig() {
    }

    public static UdpReplicationConfig simple(@NotNull InetAddress address, int port) {
        if (address.isMulticastAddress()) {
            throw new IllegalArgumentException();
        }
        return UdpReplicationConfig.create(address, port, null, ThrottlingConfig.noThrottling());
    }

    public static UdpReplicationConfig multiCast(@NotNull InetAddress address, int port, @NotNull NetworkInterface networkInterface) {
        if (!address.isMulticastAddress() || networkInterface == null) {
            throw new IllegalArgumentException();
        }
        return UdpReplicationConfig.create(address, port, networkInterface, ThrottlingConfig.noThrottling());
    }

    static UdpReplicationConfig create(InetAddress address, int port, NetworkInterface networkInterface, ThrottlingConfig throttlingConfig) {
        return new UdpReplicationConfigBean(address, port, networkInterface, throttlingConfig);
    }

    public abstract InetAddress address();

    public abstract int port();

    @Nullable
    public abstract NetworkInterface networkInterface();

    public abstract ThrottlingConfig throttlingConfig();

    public UdpReplicationConfig throttlingConfig(ThrottlingConfig throttlingConfig) {
        ThrottlingConfig.checkMillisecondBucketInterval(throttlingConfig, "UDP");
        return UdpReplicationConfig.create(this.address(), this.port(), this.networkInterface(), throttlingConfig);
    }
}

