/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.VanillaIntIntMultiMap;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class VanillaShortShortMultiMap
implements MultiMap {
    static final long MAX_CAPACITY = 65536L;
    private static final long ENTRY_SIZE = 4L;
    private static final int ENTRY_SIZE_SHIFT = 2;
    private static final int UNSET_KEY = 0;
    private static final long HASH_INSTEAD_OF_UNSET_KEY = 65535L;
    private static final int UNSET_ENTRY = 0;
    private final int capacity;
    private final long capacityMask;
    private final long capacityMask2;
    private final Bytes bytes;
    private ATSDirectBitSet positions;
    private long searchHash = -1L;
    private long searchPos = -1L;

    public VanillaShortShortMultiMap(long minCapacity) {
        assert (minCapacity <= 65536L);
        long capacity = VanillaIntIntMultiMap.multiMapCapacity(minCapacity);
        assert (Maths.isPowerOf2((long)capacity));
        this.capacity = (int)capacity;
        this.capacityMask = capacity - 1L;
        this.capacityMask2 = (capacity - 1L) * 4L;
        this.bytes = DirectStore.allocateLazy((long)(capacity * 4L)).bytes();
        this.positions = VanillaIntIntMultiMap.newPositions(capacity);
        this.clear();
    }

    public VanillaShortShortMultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        long capacity = multiMapBytes.capacity() / 4L;
        assert (Maths.isPowerOf2((long)capacity));
        assert (capacity / 2L < 65536L);
        this.capacity = (int)capacity;
        this.capacityMask = capacity - 1L;
        this.capacityMask2 = (capacity - 1L) * 4L;
        this.bytes = multiMapBytes;
        this.positions = new ATSDirectBitSet(multiMapBitSetBytes);
    }

    public static long sizeInBytes(long minCapacity) {
        return VanillaIntIntMultiMap.multiMapCapacity(minCapacity) * 4L;
    }

    public static long sizeOfBitSetInBytes(long minCapacity) {
        return VanillaIntIntMultiMap.sizeOfBitSetInBytes(minCapacity);
    }

    private void checkValueForPut(long value) {
        assert ((value & 0xFFFFFFFFFFFF0000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isClear(value)) : "Shouldn't put existing value";
    }

    private void checkValueForRemove(long value) {
        assert ((value & 0xFFFFFFFFFFFF0000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isSet(value)) : "Shouldn't remove absent value";
    }

    private static long maskUnsetKey(long key) {
        return (key &= 0xFFFFL) != 0L ? key : 65535L;
    }

    private long step(long pos) {
        return pos + 4L & this.capacityMask2;
    }

    private long stepBack(long pos) {
        return pos - 4L & this.capacityMask2;
    }

    private long pos(long key) {
        return (key & this.capacityMask) << 2;
    }

    private static int entry(long key, long value) {
        return (int)(key << 16 | value);
    }

    private static long key(int entry) {
        return entry >>> 16;
    }

    private static long value(int entry) {
        return entry & 0xFFFF;
    }

    @Override
    public void put(long key, long value) {
        key = VanillaShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForPut(value);
        long pos = this.pos(key);
        while (true) {
            int entry;
            if ((entry = this.bytes.readInt(pos)) == 0) {
                this.bytes.writeInt(pos, VanillaShortShortMultiMap.entry(key, value));
                this.positions.set(value);
                return;
            }
            pos = this.step(pos);
        }
    }

    @Override
    public void remove(long key, long value) {
        key = VanillaShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(value);
        long pos = this.pos(key);
        while (true) {
            int entry;
            if (VanillaShortShortMultiMap.key(entry = this.bytes.readInt(pos)) == key && VanillaShortShortMultiMap.value(entry) == value) break;
            pos = this.step(pos);
        }
        long posToRemove = pos;
        this.positions.clear(value);
        this.removePos(posToRemove);
    }

    @Override
    public void replace(long key, long oldValue, long newValue) {
        key = VanillaShortShortMultiMap.maskUnsetKey(key);
        this.checkValueForRemove(oldValue);
        this.checkValueForPut(newValue);
        long pos = this.pos(key);
        while (true) {
            int entry;
            if (VanillaShortShortMultiMap.key(entry = this.bytes.readInt(pos)) == key && VanillaShortShortMultiMap.value(entry) == oldValue) {
                this.positions.clear(oldValue);
                this.positions.set(newValue);
                this.bytes.writeInt(pos, VanillaShortShortMultiMap.entry(key, newValue));
                return;
            }
            pos = this.step(pos);
        }
    }

    private void removePos(long posToRemove) {
        int entryToShift;
        long posToShift = posToRemove;
        while ((entryToShift = this.bytes.readInt(posToShift = this.step(posToShift))) != 0) {
            boolean cond2;
            long insertPos = this.pos(VanillaShortShortMultiMap.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeInt(posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeInt(posToRemove, 0);
    }

    @Override
    public void startSearch(long key) {
        key = VanillaShortShortMultiMap.maskUnsetKey(key);
        this.searchPos = this.pos(key);
        this.searchHash = key;
    }

    @Override
    public long nextPos() {
        int entry;
        long pos = this.searchPos;
        do {
            if ((entry = this.bytes.readInt(pos)) == 0) {
                this.searchPos = pos;
                return -1L;
            }
            pos = this.step(pos);
        } while (VanillaShortShortMultiMap.key(entry) != this.searchHash);
        this.searchPos = pos;
        return VanillaShortShortMultiMap.value(entry);
    }

    @Override
    public void removePrevPos() {
        long prevPos = this.stepBack(this.searchPos);
        int entry = this.bytes.readInt(prevPos);
        this.positions.clear(VanillaShortShortMultiMap.value(entry));
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(long newValue) {
        this.checkValueForPut(newValue);
        long prevPos = this.stepBack(this.searchPos);
        int oldEntry = this.bytes.readInt(prevPos);
        long oldValue = VanillaShortShortMultiMap.value(oldEntry);
        this.positions.clear(oldValue);
        this.positions.set(newValue);
        this.bytes.writeInt(prevPos, VanillaShortShortMultiMap.entry(this.searchHash, newValue));
    }

    @Override
    public void putAfterFailedSearch(long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
        this.bytes.writeInt(this.searchPos, VanillaShortShortMultiMap.entry(this.searchHash, value));
    }

    @Override
    public long getSearchHash() {
        return this.searchHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt(pos);
            if (entry != 0) {
                sb.append(VanillaShortShortMultiMap.key(entry)).append('=').append(VanillaShortShortMultiMap.value(entry)).append(", ");
            }
            ++i;
            pos += 4L;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(MultiMap.EntryConsumer action) {
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            int entry = this.bytes.readInt(pos);
            if (entry != 0) {
                action.accept(VanillaShortShortMultiMap.key(entry), VanillaShortShortMultiMap.value(entry));
            }
            ++i;
            pos += 4L;
        }
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        this.bytes.zeroOut();
    }
}

