/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.hash.TcpReplicationConfig;
import net.openhft.chronicle.hash.UdpReplicationConfig;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.KeyValueSerializer;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.StatelessServerConnector;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import org.jetbrains.annotations.NotNull;

final class Replicators {
    private Replicators() {
    }

    static Replicator tcp(final TcpReplicationConfig replicationConfig) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull AbstractChronicleMapBuilder builder, @NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, ChronicleMap chronicleMap) throws IOException {
                KeyValueSerializer keyValueSerializer = new KeyValueSerializer(builder.keyBuilder, builder.valueBuilder);
                StatelessServerConnector statelessServer = new StatelessServerConnector(keyValueSerializer, (VanillaChronicleMap)chronicleMap, builder.entrySize());
                return new TcpReplicator(replica, entryExternalizable, replicationConfig, builder.entrySize(), statelessServer);
            }
        };
    }

    static Replicator udp(final UdpReplicationConfig replicationConfig) {
        return new Replicator(){

            @Override
            protected Closeable applyTo(@NotNull AbstractChronicleMapBuilder builder, @NotNull Replica map, @NotNull Replica.EntryExternalizable entryExternalizable, ChronicleMap chronicleMap) throws IOException {
                return new UdpReplicator(map, entryExternalizable, replicationConfig, builder.entrySize());
            }
        };
    }
}

