/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.Serializer;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

class KeyValueSerializer<K, V> {
    final Serializer<V> valueSerializer;
    final Serializer<K> keySerializer;

    KeyValueSerializer(SerializationBuilder<K> keySerializer, SerializationBuilder<V> valueSerializer) {
        this.keySerializer = new Serializer(keySerializer);
        this.valueSerializer = new Serializer(valueSerializer);
    }

    V readValue(Bytes reader) {
        if (this.nullCheck(reader)) {
            return null;
        }
        return this.valueSerializer.readMarshallable(reader, null);
    }

    V readValue(Bytes reader, ThreadLocalCopies local) {
        if (this.nullCheck(reader)) {
            return null;
        }
        return this.valueSerializer.readMarshallable(reader, local);
    }

    private boolean nullCheck(Bytes in) {
        return in.readBoolean();
    }

    K readKey(Bytes reader) {
        if (this.nullCheck(reader)) {
            return null;
        }
        return this.keySerializer.readMarshallable(reader, null);
    }

    K readKey(Bytes reader, ThreadLocalCopies local) {
        if (this.nullCheck(reader)) {
            return null;
        }
        return this.keySerializer.readMarshallable(reader, local);
    }

    void writeKey(K key, Bytes writer) {
        writer.writeBoolean(key == null);
        if (key != null) {
            this.keySerializer.writeMarshallable(key, writer, null);
        }
    }

    void writeValue(V value, Bytes writer) {
        assert (writer.limit() == writer.capacity());
        writer.writeBoolean(value == null);
        if (value != null) {
            this.valueSerializer.writeMarshallable(value, writer, null);
        }
    }

    void writeKey(K key, Bytes writer, ThreadLocalCopies threadLocal) {
        writer.writeBoolean(key == null);
        if (key != null) {
            this.keySerializer.writeMarshallable(key, writer, threadLocal);
        }
    }

    void writeValue(V value, Bytes writer, ThreadLocalCopies threadLocal) {
        assert (writer.limit() == writer.capacity());
        writer.writeBoolean(value == null);
        if (value != null) {
            this.valueSerializer.writeMarshallable(value, writer, threadLocal);
        }
    }

    public ThreadLocalCopies threadLocalCopies() {
        return this.valueSerializer.threadLocalCopies();
    }
}

