/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.hash.serialization.AgileBytesMarshaller;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.impl.AllocateInstanceObjectFactory;
import net.openhft.lang.model.Byteable;
import org.jetbrains.annotations.NotNull;

public class ByteableMarshaller<E extends Byteable>
implements AgileBytesMarshaller<E> {
    private static final long serialVersionUID = 0L;
    @NotNull
    private final Class<E> tClass;
    private long size;

    public static <E extends Byteable> ByteableMarshaller<E> of(@NotNull Class<E> eClass) {
        return new ByteableMarshaller<E>(eClass);
    }

    public static <E extends Byteable> ByteableMarshaller<E> of(@NotNull Class<E> eClass, ObjectFactory<E> factory) {
        if (factory instanceof AllocateInstanceObjectFactory) {
            Class allocatedClass = ((AllocateInstanceObjectFactory)factory).allocatedClass();
            return new Default(allocatedClass);
        }
        return new WithCustomFactory<E>(eClass, factory);
    }

    private ByteableMarshaller(@NotNull Class<E> tClass) {
        this.tClass = tClass;
    }

    void initSize() {
        try {
            this.size = this.getInstance().maxSize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long size(E e) {
        return this.size;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, E e) {
        Bytes input = e.bytes();
        long pos = bytes.position();
        long inputPos = e.offset();
        int i = 0;
        while ((long)i < this.size - 7L) {
            if (bytes.readLong(pos + (long)i) != input.readLong(inputPos + (long)i)) {
                return false;
            }
            i += 8;
        }
        while ((long)i < this.size) {
            if (bytes.readByte(pos + (long)i) != input.readByte(inputPos + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public long hash(E e) {
        return Hasher.hash(e.bytes(), e.offset(), e.offset() + this.size);
    }

    @Override
    public void write(Bytes bytes, E e) {
        bytes.write((RandomDataInput)e.bytes(), e.offset(), this.size);
    }

    @Override
    public long readSize(Bytes bytes) {
        return this.size;
    }

    @Override
    public E read(Bytes bytes, long size) {
        return this.read(bytes, size, (E)null);
    }

    @Override
    public E read(Bytes bytes, long size, E e) {
        try {
            if (e == null) {
                e = this.getInstance();
            }
            ByteableMarshaller.setBytesAndOffset(e, bytes);
            bytes.skip(size);
            return e;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void setBytesAndOffset(Byteable e, Bytes bytes) {
        if (bytes instanceof MultiStoreBytes) {
            MultiStoreBytes msb = (MultiStoreBytes)bytes;
            e.bytes(msb.underlyingBytes(), msb.underlyingOffset() + msb.position());
        } else {
            e.bytes(bytes, bytes.position());
        }
    }

    @NotNull
    E getInstance() throws Exception {
        return (E)((Byteable)NativeBytes.UNSAFE.allocateInstance(this.tClass));
    }

    private static class WithCustomFactory<E extends Byteable>
    extends ByteableMarshaller<E> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<E> factory;

        WithCustomFactory(@NotNull Class<E> tClass, @NotNull ObjectFactory<E> factory) {
            super(tClass);
            this.factory = factory;
            this.initSize();
        }

        @Override
        @NotNull
        E getInstance() throws Exception {
            return (E)((Byteable)this.factory.create());
        }
    }

    private static class Default<E extends Byteable>
    extends ByteableMarshaller<E> {
        private static final long serialVersionUID = 0L;

        Default(@NotNull Class<E> tClass) {
            super(tClass);
            this.initSize();
        }
    }
}

