/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;

public final class BytesReaders {
    public static <E> BytesReader<E> fromBytesMarshaller(BytesMarshaller<E> marshaller) {
        return new SimpleBytesReader<E>(marshaller);
    }

    private BytesReaders() {
    }

    private static class SimpleBytesReader<E>
    implements BytesReader<E> {
        private static final long serialVersionUID = 0L;
        private final BytesMarshaller<E> marshaller;

        public SimpleBytesReader(BytesMarshaller<E> marshaller) {
            this.marshaller = marshaller;
        }

        @Override
        public E read(Bytes bytes, long size) {
            return (E)this.marshaller.read(bytes);
        }

        @Override
        public E read(Bytes bytes, long size, E e) {
            return (E)this.marshaller.read(bytes, e);
        }
    }
}

