/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import java.io.IOException;
import net.openhft.chronicle.hash.ChannelProvider;
import net.openhft.chronicle.hash.ReplicationConfig;
import net.openhft.chronicle.hash.TcpReplicationConfig;
import net.openhft.chronicle.hash.UdpReplicationConfig;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicator;

public final class ChannelProviderBuilder {
    byte identifier;
    int maxEntrySize = 1024;
    int maxNumberOfChronicles = 128;
    private UdpReplicationConfig udpReplicationConfig = null;
    private TcpReplicationConfig tcpReplicationConfig = null;

    public int maxEntrySize() {
        return this.maxEntrySize;
    }

    public ChannelProviderBuilder maxEntrySize(int maxEntrySize) {
        this.maxEntrySize = maxEntrySize;
        return this;
    }

    public ChannelProviderBuilder replicators(byte identifier, ReplicationConfig ... replicationConfigs) {
        this.identifier = identifier;
        for (ReplicationConfig replicationConfig : replicationConfigs) {
            if (replicationConfig instanceof TcpReplicationConfig) {
                this.tcpReplicationConfig = (TcpReplicationConfig)replicationConfig;
                continue;
            }
            if (replicationConfig instanceof UdpReplicationConfig) {
                this.udpReplicationConfig = (UdpReplicationConfig)replicationConfig;
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return this;
    }

    public ChannelProviderBuilder maxNumberOfChronicles(int maxNumberOfChronicles) {
        this.maxNumberOfChronicles = maxNumberOfChronicles;
        return this;
    }

    public ChannelProvider create() throws IOException {
        ChannelProvider replicatingCluster = new ChannelProvider(this);
        if (this.tcpReplicationConfig != null) {
            TcpReplicator tcpReplicator = new TcpReplicator(replicatingCluster.asReplica, replicatingCluster.asEntryExternalizable, this.tcpReplicationConfig, this.maxEntrySize, null);
            replicatingCluster.add(tcpReplicator);
        }
        if (this.udpReplicationConfig != null) {
            UdpReplicator udpReplicator = new UdpReplicator(replicatingCluster.asReplica, replicatingCluster.asEntryExternalizable, this.udpReplicationConfig, this.maxEntrySize);
            replicatingCluster.add(udpReplicator);
        }
        return replicatingCluster;
    }
}

