/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.IntIntMultiMap;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class VanillaIntIntMultiMap
implements IntIntMultiMap {
    private static final int ENTRY_SIZE = 8;
    private static final int ENTRY_SIZE_SHIFT = 3;
    private static final int UNSET_KEY = 0;
    private static final int HASH_INSTEAD_OF_UNSET_KEY = -1;
    private static final int UNSET_VALUE = Integer.MIN_VALUE;
    private static final long UNSET_ENTRY = 0x80000000L;
    final DirectBitSet positions;
    private final int capacity;
    private final int capacityMask;
    private final long capacityMask2;
    private final Bytes bytes;
    private int searchHash = -1;
    private long searchPos = -1L;

    static int multiMapCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalArgumentException();
        }
        int capacity = Maths.nextPower2((int)minCapacity, (int)16);
        if ((double)minCapacity / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public VanillaIntIntMultiMap(int minCapacity) {
        this.capacity = VanillaIntIntMultiMap.multiMapCapacity(minCapacity);
        this.capacityMask = this.capacity - 1;
        this.capacityMask2 = VanillaIntIntMultiMap.indexToPos(this.capacity - 1);
        this.bytes = DirectStore.allocateLazy((long)VanillaIntIntMultiMap.indexToPos(this.capacity)).bytes();
        this.positions = VanillaIntIntMultiMap.newPositions(this.capacity);
        this.clear();
    }

    public VanillaIntIntMultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        this.capacity = (int)(multiMapBytes.capacity() / 8L);
        assert (this.capacity == Maths.nextPower2((int)this.capacity, (int)16));
        this.capacityMask = this.capacity - 1;
        this.capacityMask2 = VanillaIntIntMultiMap.indexToPos(this.capacity - 1);
        this.bytes = multiMapBytes;
        this.positions = new ATSDirectBitSet(multiMapBitSetBytes);
    }

    public static long sizeInBytes(int minCapacity) {
        return VanillaIntIntMultiMap.indexToPos(VanillaIntIntMultiMap.multiMapCapacity(minCapacity));
    }

    public static long sizeOfBitSetInBytes(int minCapacity) {
        return Math.max((long)VanillaIntIntMultiMap.multiMapCapacity(minCapacity), 64L) / 8L;
    }

    public static ATSDirectBitSet newPositions(int capacity) {
        capacity = Math.max(capacity, 64);
        int bitSetSizeInBytes = capacity / 8;
        return new ATSDirectBitSet((Bytes)DirectStore.allocateLazy((long)bitSetSizeInBytes).bytes());
    }

    private static long indexToPos(int index) {
        return (long)index << 3;
    }

    private static int maskUnsetKey(int key) {
        return key != 0 ? key : -1;
    }

    @Override
    public void put(int key, int value) {
        key = VanillaIntIntMultiMap.maskUnsetKey(key);
        long pos = VanillaIntIntMultiMap.indexToPos(key & this.capacityMask);
        for (int i = 0; i <= this.capacityMask; ++i) {
            int value2;
            long entry = this.bytes.readLong(pos);
            int hash2 = (int)(entry >> 32);
            if (hash2 == 0) {
                this.bytes.writeLong(pos, (long)key << 32 | (long)value & 0xFFFFFFFFL);
                this.positions.set((long)value);
                return;
            }
            if (hash2 == key && (value2 = (int)entry) == value) {
                return;
            }
            pos = pos + 8L & this.capacityMask2;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is full");
    }

    @Override
    public boolean remove(int key, int value) {
        key = VanillaIntIntMultiMap.maskUnsetKey(key);
        long pos = VanillaIntIntMultiMap.indexToPos(key & this.capacityMask);
        long posToRemove = -1L;
        for (int i = 0; i <= this.capacityMask; ++i) {
            long entry = this.bytes.readLong(pos);
            int hash2 = (int)(entry >> 32);
            if (hash2 == key) {
                int value2 = (int)entry;
                if (value2 == value) {
                    posToRemove = pos;
                    break;
                }
            } else if (hash2 == 0) break;
            pos = pos + 8L & this.capacityMask2;
        }
        if (posToRemove < 0L) {
            return false;
        }
        this.positions.clear((long)value);
        this.removePos(posToRemove);
        return true;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        key = VanillaIntIntMultiMap.maskUnsetKey(key);
        long pos = VanillaIntIntMultiMap.indexToPos(key & this.capacityMask);
        for (int i = 0; i <= this.capacityMask; ++i) {
            long entry = this.bytes.readLong(pos);
            int hash2 = (int)(entry >> 32);
            if (hash2 == key) {
                int value2 = (int)entry;
                if (value2 == oldValue) {
                    this.positions.clear((long)oldValue);
                    this.positions.set((long)newValue);
                    this.bytes.writeLong(pos, (long)key << 32 | (long)newValue & 0xFFFFFFFFL);
                    return true;
                }
            } else if (hash2 == 0) break;
            pos = pos + 8L & this.capacityMask2;
        }
        return false;
    }

    private void removePos(long posToRemove) {
        long entryToShift;
        int hash;
        long posToShift = posToRemove;
        for (int i = 0; i <= this.capacityMask && (hash = (int)((entryToShift = this.bytes.readLong(posToShift = posToShift + 8L & this.capacityMask2)) >> 32)) != 0; ++i) {
            boolean cond2;
            long insertPos = VanillaIntIntMultiMap.indexToPos(hash & this.capacityMask);
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeLong(posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeLong(posToRemove, 0x80000000L);
    }

    @Override
    public int startSearch(int key) {
        key = VanillaIntIntMultiMap.maskUnsetKey(key);
        this.searchPos = VanillaIntIntMultiMap.indexToPos(key & this.capacityMask);
        this.searchHash = key;
        return this.searchHash;
    }

    @Override
    public int nextPos() {
        long pos = this.searchPos;
        for (int i = 0; i < this.capacity; ++i) {
            long entry = this.bytes.readLong(pos);
            int hash2 = (int)(entry >> 32);
            if (hash2 == 0) {
                this.searchPos = pos;
                return Integer.MIN_VALUE;
            }
            pos = pos + 8L & this.capacityMask2;
            if (hash2 != this.searchHash) continue;
            this.searchPos = pos;
            return (int)entry;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is full");
    }

    @Override
    public void removePrevPos() {
        long prevPos = this.searchPos - 8L & this.capacityMask2;
        long entry = this.bytes.readLong(prevPos);
        int value = (int)entry;
        this.positions.clear((long)value);
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(int newValue) {
        long prevPos = this.searchPos - 8L & this.capacityMask2;
        long oldEntry = this.bytes.readLong(prevPos);
        int oldValue = (int)oldEntry;
        this.positions.clear((long)oldValue);
        this.positions.set((long)newValue);
        long newEntry = (long)this.searchHash << 32 | (long)newValue & 0xFFFFFFFFL;
        this.bytes.writeLong(prevPos, newEntry);
    }

    @Override
    public void putAfterFailedSearch(int value) {
        this.positions.set((long)value);
        long entry = (long)this.searchHash << 32 | (long)value & 0xFFFFFFFFL;
        this.bytes.writeLong(this.searchPos, entry);
    }

    @Override
    public int getSearchHash() {
        return this.searchHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        int pos = 0;
        while (i < this.capacity) {
            long entry = this.bytes.readLong((long)pos);
            int key = (int)(entry >> 32);
            int value = (int)entry;
            if (key != 0) {
                sb.append(key).append('=').append(value).append(", ");
            }
            ++i;
            pos += 8;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(IntIntMultiMap.EntryConsumer action) {
        int i = 0;
        int pos = 0;
        while (i < this.capacity) {
            long entry = this.bytes.readLong((long)pos);
            int key = (int)(entry >> 32);
            int value = (int)entry;
            if (key != 0) {
                action.accept(key, value);
            }
            ++i;
            pos += 8;
        }
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        int pos = 0;
        while ((long)pos < this.bytes.capacity()) {
            this.bytes.writeLong((long)pos, 0x80000000L);
            pos += 8;
        }
    }
}

