/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.internal.BasicCopyingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DirectBytesBuffer;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class CopyingMetaBytesInterop<E, W>
extends BasicCopyingMetaBytesInterop<E, W> {
    private static final long serialVersionUID = 1L;
    private static final long MAX_REASONABLE_SERIALIZED_SIZE = MemoryUnit.MEGABYTES.toBytes(512L);
    transient W writer;
    transient E cur;

    public static void checkMaxSizeStillReasonable(long maxSize, Exception ex) {
        if (maxSize > MAX_REASONABLE_SERIALIZED_SIZE) {
            throw new IllegalStateException("We try to figure out size of objects in serialized form, but it exceeds " + MAX_REASONABLE_SERIALIZED_SIZE + " bytes. We assume this is " + "a error and throw exception at this point. If you really " + "want larger keys/values, use ChronicleMapBuilder." + "keySize(int)/valueSize(int)/entrySize(int) configurations", ex);
        }
    }

    protected CopyingMetaBytesInterop(DirectBytesBuffer buffer) {
        super(buffer);
    }

    void init(W writer, E e, boolean mutable, long maxSize) {
        if (mutable || writer != this.writer || e != this.cur) {
            this.writer = writer;
            this.cur = e;
            while (true) {
                try {
                    Bytes buffer = this.buffer.obtain(maxSize);
                    this.innerWrite(writer, buffer, e);
                    buffer.flip();
                    this.size = buffer.remaining();
                    this.hash = 0L;
                    return;
                }
                catch (Exception ex) {
                    CopyingMetaBytesInterop.checkMaxSizeStillReasonable(maxSize, ex);
                    maxSize *= 2L;
                    continue;
                }
                break;
            }
        }
    }

    abstract void innerWrite(W var1, Bytes var2, E var3);

    DirectBytesBuffer buffer() {
        return this.buffer;
    }

    public static <E, M extends BytesMarshaller<E>> MetaBytesInterop<E, M> forBytesMarshaller(Serializable bufferIdentity) {
        return new DirectBytesBuffer((Serializable)bufferIdentity).forBytesMarshaller;
    }

    public static <E, W extends BytesWriter<E>> MetaBytesInterop<E, W> forBytesWriter(Serializable bufferIdentity) {
        return new DirectBytesBuffer((Serializable)bufferIdentity).forBytesWriter;
    }

    public static <E, M extends BytesMarshaller<E>> MetaProvider<E, M, CopyingMetaBytesInterop<E, M>> providerForBytesMarshaller(boolean mutable, long maxSize) {
        return new BytesMarshallerCopyingMetaBytesInteropProvider(mutable, maxSize);
    }

    public static <E, W extends BytesWriter<E>> MetaProvider<E, W, CopyingMetaBytesInterop<E, W>> providerForBytesWriter(boolean mutable, long maxSize) {
        return new BytesWriterCopyingMetaBytesInteropProvider(mutable, maxSize);
    }

    private static class BytesWriterCopyingMetaBytesInteropProvider<E, W extends BytesWriter<E>>
    extends BasicCopyingMetaBytesInterop.BasicCopyingMetaBytesInteropProvider<E, W, CopyingMetaBytesInterop<E, W>> {
        private static final long serialVersionUID = 0L;
        private final boolean mutable;
        private final long maxSize;

        public BytesWriterCopyingMetaBytesInteropProvider(boolean mutable, long maxSize) {
            this.mutable = mutable;
            this.maxSize = maxSize;
        }

        @Override
        public CopyingMetaBytesInterop<E, W> get(ThreadLocalCopies copies, CopyingMetaBytesInterop<E, W> originalMetaWriter, W writer, E e) {
            DirectBytesBuffer.ForBytesWriter forBytesWriter = ((DirectBytesBuffer)BasicCopyingMetaBytesInterop.provider.get((ThreadLocalCopies)copies, (Object)originalMetaWriter.buffer())).forBytesWriter;
            forBytesWriter.init(writer, e, this.mutable, this.maxSize);
            return forBytesWriter;
        }
    }

    private static class BytesMarshallerCopyingMetaBytesInteropProvider<E, M extends BytesMarshaller<E>>
    extends BasicCopyingMetaBytesInterop.BasicCopyingMetaBytesInteropProvider<E, M, CopyingMetaBytesInterop<E, M>> {
        private static final long serialVersionUID = 0L;
        private final boolean mutable;
        private final long maxSize;

        public BytesMarshallerCopyingMetaBytesInteropProvider(boolean mutable, long maxSize) {
            this.mutable = mutable;
            this.maxSize = maxSize;
        }

        @Override
        public CopyingMetaBytesInterop<E, M> get(ThreadLocalCopies copies, CopyingMetaBytesInterop<E, M> originalMetaWriter, M writer, E e) {
            DirectBytesBuffer.ForBytesMarshaller forBytesMarshaller = ((DirectBytesBuffer)BasicCopyingMetaBytesInterop.provider.get((ThreadLocalCopies)copies, (Object)originalMetaWriter.buffer())).forBytesMarshaller;
            forBytesMarshaller.init(writer, e, this.mutable, this.maxSize);
            return forBytesMarshaller;
        }
    }
}

