/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.DeserializationFactoryConfigurableBytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.model.Byteable;
import org.jetbrains.annotations.NotNull;

public abstract class ByteableMarshaller<E extends Byteable>
implements BytesInterop<E>,
DeserializationFactoryConfigurableBytesReader<E, ByteableMarshaller<E>>,
SizeMarshaller {
    private static final long serialVersionUID = 0L;
    @NotNull
    private final Class<E> tClass;
    private long size;

    public static <E extends Byteable> ByteableMarshaller<E> of(@NotNull Class<E> eClass) {
        return new Default<E>(eClass);
    }

    @Override
    public ByteableMarshaller<E> withDeserializationFactory(ObjectFactory<E> deserializationFactory) {
        return new WithCustomFactory<E>(this.tClass, deserializationFactory);
    }

    private ByteableMarshaller(@NotNull Class<E> tClass) {
        this.tClass = tClass;
    }

    void initSize() {
        try {
            this.size = this.getInstance().maxSize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long size(E e) {
        return this.size;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, E e) {
        if (bytes.capacity() - bytes.position() < this.size) {
            return false;
        }
        Bytes input = e.bytes();
        long pos = bytes.position();
        long inputPos = e.offset();
        int i = 0;
        while ((long)i < this.size - 7L) {
            if (bytes.readLong(pos + (long)i) != input.readLong(inputPos + (long)i)) {
                return false;
            }
            i += 8;
        }
        while ((long)i < this.size) {
            if (bytes.readByte(pos + (long)i) != input.readByte(inputPos + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public long hash(E e) {
        return Hasher.hash(e.bytes(), e.offset(), e.offset() + this.size);
    }

    @Override
    public void write(Bytes bytes, E e) {
        Bytes eBytes = e.bytes();
        if (eBytes == null) {
            throw new NullPointerException("You are trying to write a byteable object of " + e.getClass() + ", " + "which bytes are not assigned. I. e. most likely the object is uninitialized.");
        }
        bytes.write((RandomDataInput)eBytes, e.offset(), this.size);
    }

    @Override
    public long readSize(Bytes bytes) {
        return this.size;
    }

    @Override
    public E read(Bytes bytes, long size) {
        return this.read(bytes, size, (E)null);
    }

    @Override
    public E read(Bytes bytes, long size, E toReuse) {
        try {
            if (toReuse == null) {
                toReuse = this.getInstance();
            }
            ByteableMarshaller.setBytesAndOffset(toReuse, bytes);
            bytes.skip(size);
            return toReuse;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void setBytesAndOffset(Byteable e, Bytes bytes) {
        if (bytes instanceof MultiStoreBytes) {
            MultiStoreBytes msb = (MultiStoreBytes)bytes;
            e.bytes(msb.underlyingBytes(), msb.underlyingOffset() + msb.position());
        } else {
            e.bytes(bytes, bytes.position());
        }
    }

    @NotNull
    E getInstance() throws Exception {
        return (E)((Byteable)NativeBytes.UNSAFE.allocateInstance(this.tClass));
    }

    private static class WithCustomFactory<E extends Byteable>
    extends ByteableMarshaller<E> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<E> factory;

        WithCustomFactory(@NotNull Class<E> tClass, @NotNull ObjectFactory<E> factory) {
            super(tClass);
            this.factory = factory;
            this.initSize();
        }

        @Override
        @NotNull
        E getInstance() throws Exception {
            return (E)((Byteable)this.factory.create());
        }
    }

    private static class Default<E extends Byteable>
    extends ByteableMarshaller<E> {
        private static final long serialVersionUID = 0L;

        Default(@NotNull Class<E> tClass) {
            super(tClass);
            this.initSize();
        }
    }
}

