/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;

final class MapInstanceConfig<K, V>
implements ChronicleHashInstanceConfig<ChronicleMap<K, V>> {
    final ChronicleMapBuilder<K, V> mapBuilder;
    final SingleChronicleHashReplication singleHashReplication;
    final ReplicationChannel channel;
    final File file;
    final String name;
    final AtomicBoolean used;

    MapInstanceConfig(ChronicleMapBuilder<K, V> mapBuilder, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel, File file, String name, AtomicBoolean used) {
        this.mapBuilder = mapBuilder;
        this.singleHashReplication = singleHashReplication;
        this.channel = channel;
        this.file = file;
        this.name = name;
        this.used = used;
    }

    public MapInstanceConfig<K, V> replicated(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replicated(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    public MapInstanceConfig<K, V> replicated(SingleChronicleHashReplication replication) {
        return new MapInstanceConfig<K, V>(this.mapBuilder, replication, null, this.file, this.name, this.used);
    }

    public MapInstanceConfig<K, V> replicatedViaChannel(ReplicationChannel channel) {
        return new MapInstanceConfig<K, V>(this.mapBuilder, null, channel, this.file, this.name, this.used);
    }

    public MapInstanceConfig<K, V> persistedTo(File file) {
        return new MapInstanceConfig<K, V>(this.mapBuilder, this.singleHashReplication, this.channel, file, this.name, this.used);
    }

    public MapInstanceConfig<K, V> name(String name) {
        return new MapInstanceConfig<K, V>(this.mapBuilder, this.singleHashReplication, this.channel, this.file, name, this.used);
    }

    @Override
    public synchronized ChronicleMap<K, V> create() throws IOException {
        if (!this.used.getAndSet(true)) {
            return this.mapBuilder.create(this);
        }
        throw new IllegalStateException("A ChronicleMap has already been created using this instance config chain. Create a new instance config (builder.instance()) to create a new ChronicleMap instance");
    }
}

