/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.FindByName;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.MapEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicationHubFindByName<K>
implements FindByName {
    public static final Logger LOG = LoggerFactory.getLogger((String)ReplicationHubFindByName.class.getName());
    public static final int MAP_BY_NAME_CHANNEL = 1;
    private final AtomicInteger nextFreeChannel = new AtomicInteger(2);
    private final Map<String, ChronicleMapBuilderWithChannelId> map;
    private final ReplicationHub replicationHub;

    public ReplicationHubFindByName(ReplicationHub replicationHub) throws IOException {
        LOG.info("connecting to replicationHub=" + replicationHub);
        this.replicationHub = replicationHub;
        ReplicationChannel channel = replicationHub.createChannel(1);
        MapEventListener<CharSequence, ChronicleMapBuilderWithChannelId> listener = new MapEventListener<CharSequence, ChronicleMapBuilderWithChannelId>(){

            @Override
            public void onPut(CharSequence key, ChronicleMapBuilderWithChannelId value, ChronicleMapBuilderWithChannelId replacedValue) {
                boolean added;
                super.onPut(key, value, replacedValue);
                boolean bl = added = replacedValue == null;
                if (!added || value == null) {
                    return;
                }
                LOG.info("create new map for name=" + value.chronicleMapBuilder.name() + ",channelId=" + value.channelId);
                try {
                    ReplicationHubFindByName.this.toReplicatedViaChannel(value.chronicleMapBuilder, value.channelId).create();
                }
                catch (IllegalStateException e) {
                    LOG.debug("while creating channel for name=" + value.chronicleMapBuilder.name() + ",channelId=" + value.channelId, (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        };
        this.map = ((ChronicleMapBuilder)((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMapBuilder.of(CharSequence.class, ChronicleMapBuilderWithChannelId.class).entrySize(3000)).entries(128L)).eventListener((MapEventListener)listener)).instance().replicatedViaChannel(channel).create();
        if (LOG.isDebugEnabled()) {
            LOG.debug("map=" + this.map);
        }
    }

    public <T extends ChronicleHash> T create(ChronicleMapBuilder<CharSequence, CharSequence> builder) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        int withChannelId = this.nextFreeChannel.incrementAndGet();
        ChronicleMapBuilderWithChannelId builderWithChannelId = new ChronicleMapBuilderWithChannelId();
        builderWithChannelId.channelId = withChannelId;
        builderWithChannelId.chronicleMapBuilder = builder;
        this.map.put(builder.name(), builderWithChannelId);
        return (T)this.get((String)builder.name()).chronicleMapBuilder.create();
    }

    @Override
    public <T extends ChronicleHash> T from(String name) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)this.replicatedViaChannel(name).create();
    }

    ChronicleMapBuilderWithChannelId get(String name) throws IllegalArgumentException, TimeoutException, InterruptedException {
        ChronicleMapBuilderWithChannelId chronicleMapBuilder = this.waitTillEntryReceived(5000, name);
        if (chronicleMapBuilder == null) {
            throw new IllegalArgumentException("A map name=" + name + " can not be found.");
        }
        return chronicleMapBuilder;
    }

    private ChronicleMapBuilderWithChannelId waitTillEntryReceived(int timeOutMs, String name) throws TimeoutException, InterruptedException {
        for (int t = 0; t < timeOutMs; ++t) {
            ChronicleMapBuilderWithChannelId builder = this.map.get(name);
            if (builder != null) {
                return builder;
            }
            Thread.sleep(1L);
        }
        throw new TimeoutException("timed out wait for map name=" + name);
    }

    private ChronicleHashInstanceConfig replicatedViaChannel(String name) throws TimeoutException, InterruptedException {
        ChronicleMapBuilderWithChannelId builder = this.get(name);
        return this.toReplicatedViaChannel(builder.chronicleMapBuilder, builder.channelId);
    }

    public <T extends ChronicleHash> T createPersistedTo(String name, File file) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)this.replicatedViaChannel(name).persistedTo(file).create();
    }

    private ChronicleHashInstanceConfig toReplicatedViaChannel(ChronicleMapBuilder builder) {
        int channelId = this.nextFreeChannel.incrementAndGet();
        if (channelId > this.replicationHub.maxNumberOfChannels()) {
            throw new IllegalStateException("There are no more free channels, you can increase the number of changes in the replicationHub by calling replicationHub.maxNumberOfChannels(..);");
        }
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)channelId));
    }

    private ChronicleHashInstanceConfig toReplicatedViaChannel(ChronicleHashBuilder<K, ?, ?> builder, int withChannelId) {
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)withChannelId));
    }

    public static class ChronicleMapBuilderWithChannelId<K, V>
    implements Serializable {
        ChronicleHashBuilder<K, ChronicleMap<K, V>, ?> chronicleMapBuilder;
        int channelId;
    }
}

