/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.serialization.internal.ByteableMarshaller;
import net.openhft.chronicle.hash.serialization.internal.LongValueKeyMarshaller;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.values.LongValue;

public final class LongValueValueMarshaller
extends LongValueKeyMarshaller {
    private static final long serialVersionUID = 0L;
    public static final LongValueValueMarshaller INSTANCE = new LongValueValueMarshaller();
    private static final Class<LongValue> directLongValueClass = DataValueClasses.directClassFor(LongValue.class);

    private LongValueValueMarshaller() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public LongValue read(Bytes bytes, long size, LongValue toReuse) {
        if (!(toReuse instanceof Byteable)) {
            try {
                toReuse = directLongValueClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
        }
        Byteable value = (Byteable)toReuse;
        ByteableMarshaller.setBytesAndOffset(value, bytes);
        bytes.skip(8L);
        return toReuse;
    }
}

