/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.EntryReader;
import net.openhft.chronicle.map.EntryWriter;
import net.openhft.chronicle.map.UdpChannelReplicator;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeDiscoveryBroadcaster
extends UdpChannelReplicator {
    public static final Logger LOG = LoggerFactory.getLogger((String)NodeDiscoveryBroadcaster.class.getName());
    private static final byte UNUSED = -1;
    static final ByteBufferBytes BOOTSTRAP_BYTES;

    static String toString(DirectBitSet bitSet) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((long)i < bitSet.size()) {
            builder.append(bitSet.get((long)i) ? (char)'1' : '0');
            ++i;
        }
        return builder.toString();
    }

    NodeDiscoveryBroadcaster(UdpTransportConfig replicationConfig, int serializedEntrySize, BytesMarshallable externalizable) throws IOException {
        super(replicationConfig, serializedEntrySize, (byte)-1);
        UdpSocketChannelEntryWriter writer = new UdpSocketChannelEntryWriter(1024, externalizable, this);
        UdpSocketChannelEntryReader reader = new UdpSocketChannelEntryReader(1024, externalizable);
        this.setReader(reader);
        this.setWriter(writer);
        this.start();
    }

    static {
        String BOOTSTRAP = "BOOTSTRAP";
        BOOTSTRAP_BYTES = new ByteBufferBytes(ByteBuffer.allocate(2 + "BOOTSTRAP".length()));
        BOOTSTRAP_BYTES.write((int)((short)"BOOTSTRAP".length()));
        BOOTSTRAP_BYTES.append((CharSequence)"BOOTSTRAP");
    }

    static class UdpSocketChannelEntryWriter
    implements EntryWriter {
        private final ByteBuffer out;
        private final ByteBufferBytes in;
        @NotNull
        private final BytesMarshallable externalizable;
        private UdpChannelReplicator udpReplicator;

        UdpSocketChannelEntryWriter(int serializedEntrySize, @NotNull BytesMarshallable externalizable, @NotNull UdpChannelReplicator udpReplicator) {
            this.externalizable = externalizable;
            this.udpReplicator = udpReplicator;
            this.out = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.in = new ByteBufferBytes(this.out);
        }

        @Override
        public int writeAll(@NotNull DatagramChannel socketChannel) throws InterruptedException, IOException {
            this.out.clear();
            this.in.clear();
            this.in.skip(4L);
            this.in.skip(4L);
            long start = this.in.position();
            this.externalizable.writeMarshallable((Bytes)this.in);
            long size = this.in.position() - start;
            this.in.writeInt(0L, ~((int)size));
            this.in.writeInt(4L, (int)size);
            this.out.limit((int)this.in.position());
            this.udpReplicator.disableWrites();
            return socketChannel.write(this.out);
        }
    }

    static class UdpSocketChannelEntryReader
    implements EntryReader {
        private final ByteBuffer in;
        private final ByteBufferBytes out;
        private final BytesMarshallable externalizable;

        UdpSocketChannelEntryReader(int serializedEntrySize, @NotNull BytesMarshallable externalizable) {
            this.in = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.out = new ByteBufferBytes(this.in);
            this.out.limit(0L);
            this.in.clear();
            this.externalizable = externalizable;
        }

        @Override
        public void readAll(@NotNull DatagramChannel socketChannel) throws IOException, InterruptedException {
            this.out.clear();
            this.in.clear();
            socketChannel.receive(this.in);
            int bytesRead = this.in.position();
            if (bytesRead < 8) {
                return;
            }
            this.out.limit((long)this.in.position());
            int invertedSize = this.out.readInt();
            int size = this.out.readInt();
            if (~size != invertedSize) {
                return;
            }
            if (this.out.remaining() != (long)size) {
                return;
            }
            this.externalizable.readMarshallable((Bytes)this.out);
        }
    }
}

