/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashErrorListeners;
import net.openhft.chronicle.hash.ChronicleHashInstanceConfig;
import net.openhft.chronicle.hash.StatelessClientConfig;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChannelProvider;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.InstanceConfig;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapEventListeners;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.NullValueProvider;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.StatelessMapConfig;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.lang.Maths;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleMapBuilder<K, V, B extends AbstractChronicleMapBuilder<K, V, B>>
implements Cloneable,
ChronicleHashBuilder<K, ChronicleMap<K, V>, B> {
    static final short UDP_REPLICATION_MODIFICATION_ITERATOR_ID = 128;
    private static final Bytes EMPTY_BYTES = new ByteBufferBytes(ByteBuffer.allocate(0));
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final int MAX_SEGMENTS_TO_CHAISE_COMPACT_MULTI_MAPS = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractChronicleMapBuilder.class.getName());
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private int minSegments = -1;
    private int actualSegments = -1;
    private long actualEntriesPerSegment = -1L;
    private int keySize = 0;
    private K sampleKey;
    private int valueSize = 0;
    private V sampleValue;
    private int entrySize = 0;
    private Alignment alignment = null;
    private long entries = 0x100000L;
    private long lockTimeOut = 2000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private int metaDataBytes = 0;
    private ChronicleHashErrorListener errorListener = ChronicleHashErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private MapEventListener<K, V, ChronicleMap<K, V>> eventListener = MapEventListeners.nop();
    private V defaultValue = null;
    private DefaultValueProvider<K, V> defaultValueProvider = NullValueProvider.INSTANCE;
    private PrepareValueBytes<K, V> prepareValueBytes = null;
    private SingleChronicleHashReplication singleHashReplication = null;

    AbstractChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
    }

    protected static boolean offHeapReference(Class valueClass) {
        return Byteable.class.isAssignableFrom(valueClass);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    private static void checkSegments(int segments) {
        if (segments <= 0 || segments > 0x40000000) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static long divideUpper(long dividend, long divisor) {
        return (dividend - 1L) / divisor + 1L;
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    @Override
    public B clone() {
        try {
            AbstractChronicleMapBuilder result = (AbstractChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            return (B)result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    abstract B self();

    @Override
    public B keySize(int keySize) {
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size must be positive");
        }
        this.keySize = keySize;
        return this.self();
    }

    @Override
    public B constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        return this.self();
    }

    private int keySize() {
        return this.keyOrValueSize(this.keySize, this.keyBuilder);
    }

    B valueSize(int valueSize) {
        if (valueSize <= 0) {
            throw new IllegalArgumentException("Value size must be positive");
        }
        this.valueSize = valueSize;
        return this.self();
    }

    B constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        return this.self();
    }

    int valueSize() {
        return this.keyOrValueSize(this.valueSize, this.valueBuilder);
    }

    private int keyOrValueSize(int configuredSize, SerializationBuilder builder) {
        if (configuredSize > 0) {
            return configuredSize;
        }
        if (builder.sizeMarshaller().sizeEncodingSize(0L) == 0) {
            return (int)builder.sizeMarshaller().readSize(EMPTY_BYTES);
        }
        return 120;
    }

    @Override
    public B entrySize(int entrySize) {
        if (entrySize <= 0) {
            throw new IllegalArgumentException("Entry Size must be positive");
        }
        this.entrySize = entrySize;
        return this.self();
    }

    int entrySize(boolean replicated) {
        if (this.entrySize > 0) {
            return this.entryAndValueAlignment().alignSize(this.entrySize);
        }
        int size = this.metaDataBytes;
        int keySize = this.keySize();
        size += this.keyBuilder.sizeMarshaller().sizeEncodingSize(keySize);
        size += keySize;
        if (replicated) {
            size += 10;
        }
        int valueSize = this.valueSize();
        size += this.valueBuilder.sizeMarshaller().sizeEncodingSize(valueSize);
        size = this.entryAndValueAlignment().alignSize(size);
        size += valueSize;
        for (int i = 1; i <= 4; ++i) {
            int bound = i * 64;
            if (size >= bound || bound - size > bound / 20) continue;
            size = bound;
            break;
        }
        return this.entryAndValueAlignment().alignSize(size);
    }

    B entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this.self();
    }

    Alignment entryAndValueAlignment() {
        if (this.alignment != null) {
            return this.alignment;
        }
        return AbstractChronicleMapBuilder.offHeapReference(this.valueBuilder.eClass) ? Alignment.OF_4_BYTES : Alignment.NO_ALIGNMENT;
    }

    @Override
    public B entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this.self();
    }

    long entries() {
        return this.entries;
    }

    @Override
    public B actualEntriesPerSegment(long actualEntriesPerSegment) {
        if (actualEntriesPerSegment <= 0L) {
            throw new IllegalArgumentException("entries per segment should be positive, " + actualEntriesPerSegment + " given");
        }
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalArgumentException("max entries per segment is 4294967296, " + actualEntriesPerSegment + " given");
        }
        this.actualEntriesPerSegment = actualEntriesPerSegment;
        return this.self();
    }

    private boolean tooManyEntriesPerSegment(long entriesPerSegment) {
        return entriesPerSegment > 0x100000000L;
    }

    long actualEntriesPerSegment() {
        if (this.actualEntriesPerSegment > 0L) {
            return this.actualEntriesPerSegment;
        }
        int actualSegments = this.actualSegments();
        long actualEntries = this.totalEntriesIfPoorDistribution(actualSegments);
        long actualEntriesPerSegment = AbstractChronicleMapBuilder.divideUpper(actualEntries, actualSegments);
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalStateException("max entries per segment is 4294967296 configured entries() and actualSegments() so that there should be " + actualEntriesPerSegment + " entries per segment");
        }
        return actualEntriesPerSegment;
    }

    private long totalEntriesIfPoorDistribution(int segments) {
        if (segments == 1) {
            return this.entries;
        }
        double poorDistEntriesScale = Math.log(segments) * (double)this.entries;
        return Math.min(this.entries * (long)segments, (long)((double)this.entries + poorDistEntriesScale * 0.14 + 32.0));
    }

    @Override
    public B minSegments(int minSegments) {
        AbstractChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this.self();
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2((long)(this.entries / 32L), (long)1L), (long)this.estimateSegementBasedOnSize());
    }

    private int estimateSegementBasedOnSize() {
        long size = (long)(Math.log10(this.entrySize + 32) / 2.0 * (double)this.entries);
        if (size < 10000L) {
            return 512;
        }
        if (size < 100000L) {
            return 1024;
        }
        if (size < 1000000L) {
            return 2048;
        }
        if (size < 10000000L) {
            return 4096;
        }
        if (size < 100000000L) {
            return 8192;
        }
        return 16384;
    }

    @Override
    public B actualSegments(int actualSegments) {
        AbstractChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this.self();
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        long shortMMapSegments = this.trySegments(65536L, 0x100000);
        if (shortMMapSegments > 0L) {
            return (int)shortMMapSegments;
        }
        long intMMapSegments = this.trySegments(0x100000000L, 0x40000000);
        if (intMMapSegments > 0L) {
            return (int)intMMapSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries() that builder automatically decided to use " + -intMMapSegments + " segments");
    }

    private long trySegments(long maxSegmentCapacity, int maxSegments) {
        long segments = AbstractChronicleMapBuilder.divideUpper(this.totalEntriesIfPoorDistribution(this.minSegments()), maxSegmentCapacity);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    int segmentHeaderSize() {
        int segments = this.actualSegments();
        return segments <= 16384 ? 64 : 32;
    }

    MultiMapFactory multiMapFactory() {
        return MultiMapFactory.forCapacity(this.actualEntriesPerSegment());
    }

    @Override
    public B lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.lockTimeOut = lockTimeOut;
        this.lockTimeOutUnit = unit;
        return this.self();
    }

    long lockTimeOut(TimeUnit unit) {
        return unit.convert(this.lockTimeOut, this.lockTimeOutUnit);
    }

    @Override
    public B errorListener(ChronicleHashErrorListener errorListener) {
        this.errorListener = errorListener;
        return this.self();
    }

    ChronicleHashErrorListener errorListener() {
        return this.errorListener;
    }

    public B putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this.self();
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public B removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this.self();
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public B metaDataBytes(int metaDataBytes) {
        if ((metaDataBytes & 0xFF) != metaDataBytes) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this.self();
    }

    int metaDataBytes() {
        return this.metaDataBytes;
    }

    public String toString() {
        return "ChronicleMapBuilder{actualSegments=" + AbstractChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + AbstractChronicleMapBuilder.pretty(this.minSegments) + ", actualEntriesPerSegment=" + AbstractChronicleMapBuilder.pretty(this.actualEntriesPerSegment) + ", keySize=" + AbstractChronicleMapBuilder.pretty(this.keySize) + ", sampleKeyForConstantSizeComputation=" + AbstractChronicleMapBuilder.pretty(this.sampleKey) + ", valueSize=" + AbstractChronicleMapBuilder.pretty(this.valueSize) + ", sampleValueForConstantSizeComputation=" + AbstractChronicleMapBuilder.pretty(this.sampleValue) + ", entrySize=" + AbstractChronicleMapBuilder.pretty(this.entrySize) + ", entryAndValueAlignment=" + (Object)((Object)this.entryAndValueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + AbstractChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + AbstractChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", eventListener=" + this.eventListener + ", defaultValue=" + this.defaultValue + ", defaultValueProvider=" + AbstractChronicleMapBuilder.pretty(this.defaultValueProvider) + ", prepareValueBytes=" + AbstractChronicleMapBuilder.pretty(this.prepareValueBytes) + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this.self();
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public B bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this.self();
    }

    ObjectSerializer objectSerializer() {
        return this.objectSerializer == null ? (this.objectSerializer = BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)JDKObjectSerializer.INSTANCE)) : this.objectSerializer;
    }

    @Override
    public B objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this.self();
    }

    @Override
    public B keyMarshaller(@NotNull BytesMarshaller<K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller);
        return this.self();
    }

    @Override
    public B keyMarshallers(@NotNull BytesWriter<K> keyWriter, @NotNull BytesReader<K> keyReader) {
        this.keyBuilder.writer(keyWriter);
        this.keyBuilder.reader(keyReader);
        return this.self();
    }

    @Override
    public B keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this.self();
    }

    @Override
    public B keyDeserializationFactory(@NotNull ObjectFactory<K> keyDeserializationFactory) {
        this.keyBuilder.factory(keyDeserializationFactory);
        return this.self();
    }

    @Override
    public B immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this.self();
    }

    @Override
    public StatelessClientConfig<ChronicleMap<K, V>> statelessClient(InetSocketAddress remoteAddress) {
        return new StatelessMapConfig(this.clone(), remoteAddress);
    }

    public B valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.valueBuilder.factory(valueDeserializationFactory);
        return this.self();
    }

    public B eventListener(MapEventListener<K, V, ChronicleMap<K, V>> eventListener) {
        this.eventListener = eventListener;
        return this.self();
    }

    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.eventListener;
    }

    public B defaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultValueProvider = null;
        if (defaultValue == null) {
            this.defaultValueProvider = NullValueProvider.INSTANCE;
        }
        this.prepareValueBytes = null;
        return this.self();
    }

    public B defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        this.defaultValue = null;
        this.prepareValueBytes = null;
        return this.self();
    }

    B prepareValueBytesOnAcquire(@NotNull PrepareValueBytes<K, V> prepareValueBytes) {
        this.prepareValueBytes = prepareValueBytes;
        this.defaultValue = null;
        this.defaultValueProvider = null;
        return this.self();
    }

    PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter() {
        return new PrepareValueBytesAsWriter<K>(this.prepareValueBytes, this.valueSize());
    }

    DefaultValueProvider<K, V> defaultValueProvider() {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider;
        }
        if (this.defaultValue == null) {
            return null;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, this.defaultValue);
        return new ConstantValueProvider(this.defaultValue, metaValueWriter, valueWriter);
    }

    @Override
    public B replication(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        return this.self();
    }

    @Override
    public B replication(byte identifier) {
        return (B)this.replication(SingleChronicleHashReplication.builder().createWithId(identifier));
    }

    @Override
    public B replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return (B)this.replication(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    @Override
    public ChronicleHashInstanceConfig<ChronicleMap<K, V>> instance() {
        return new InstanceConfig(this.clone(), this.singleHashReplication, null, null);
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return ((AbstractChronicleMapBuilder)this.clone()).createWithFile(file, this.singleHashReplication, null);
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        return ((AbstractChronicleMapBuilder)this.clone()).createWithoutFile(this.singleHashReplication, null);
    }

    ChronicleMap<K, V> create(InstanceConfig<K, V> ib) throws IOException {
        if (ib.file != null) {
            return this.createWithFile(ib.file, ib.singleHashReplication, ib.channel);
        }
        return this.createWithoutFile(ib.singleHashReplication, ib.channel);
    }

    /*
     * Exception decompiling
     */
    ChronicleMap<K, V> createWithFile(File file, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ChronicleMap<K, V> createReplicated(byte identifier) throws IOException {
        this.preMapConstruction(true);
        ReplicatedChronicleMap map = new ReplicatedChronicleMap(this, identifier);
        DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
        map.createMappedStoreAndSegments((BytesStore)bytesStore);
        return map;
    }

    ChronicleMap<K, V> createWithoutFile(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap(singleHashReplication, channel);
        DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
        map.createMappedStoreAndSegments((BytesStore)bytesStore);
        return this.establishReplication(map, singleHashReplication, channel);
    }

    ChronicleMap<K, V> createStatelessMap(StatelessMapConfig<K, V> statelessBuilder) throws IOException {
        this.preMapConstruction(false);
        return new StatelessChronicleMap(statelessBuilder, this);
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?> newMap(SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        boolean replicated = singleHashReplication != null || channel != null;
        this.preMapConstruction(replicated);
        if (replicated) {
            byte identifier = singleHashReplication != null ? singleHashReplication.identifier() : channel.hub().identifier();
            return new ReplicatedChronicleMap(this, identifier);
        }
        return new VanillaChronicleMap(this);
    }

    void preMapConstruction(boolean replicated) {
        this.keyBuilder.objectSerializer(this.objectSerializer());
        this.valueBuilder.objectSerializer(this.objectSerializer());
        long maxSize = (long)this.entrySize(replicated) * (long)this.figureBufferAllocationFactor();
        this.keyBuilder.maxSize(maxSize);
        this.valueBuilder.maxSize(maxSize);
        if (this.sampleKey != null) {
            this.keyBuilder.constantSizeBySample(this.sampleKey);
        }
        if (this.sampleValue != null) {
            this.valueBuilder.constantSizeBySample(this.sampleValue);
        }
    }

    private ChronicleMap<K, V> establishReplication(VanillaChronicleMap<K, ?, ?, V, ?, ?> map, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            if (singleHashReplication != null && channel != null) {
                throw new AssertionError((Object)"Only one non-null replication should be passed");
            }
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            ArrayList<Replicator> replicators = new ArrayList<Replicator>(2);
            if (singleHashReplication != null) {
                if (singleHashReplication.tcpTransportAndNetwork() != null) {
                    replicators.add(Replicators.tcp(singleHashReplication));
                }
                if (singleHashReplication.udpTransport() != null) {
                    replicators.add(Replicators.udp(singleHashReplication.udpTransport()));
                }
            } else {
                ReplicationHub hub = channel.hub();
                int entrySize = this.entrySize(true);
                if (entrySize > hub.maxEntrySize()) {
                    throw new IllegalArgumentException("During ChannelProviderBuilder setup, maxEntrySize=" + hub.maxEntrySize() + " was specified, but map with " + "entrySize=" + entrySize + " is attempted to apply to the replicator");
                }
                ChannelProvider provider = ChannelProvider.getProvider(hub);
                ChannelProvider.ChronicleChannel ch = provider.createChannel(channel.channelId());
                replicators.add(ch);
            }
            for (Replicator replicator : replicators) {
                Closeable token = replicator.applyTo(this, result, result, map);
                if (replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private int figureBufferAllocationFactor() {
        return (int)Math.min(Math.max(2L, this.entries() >> 10), 64L);
    }
}

