/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.values.LongValue;

public enum LongValueMarshaller implements BytesInterop<LongValue>,
BytesReader<LongValue>,
SizeMarshaller
{
    INSTANCE;


    @Override
    public long size(LongValue e) {
        return 8L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, LongValue e) {
        return e.getValue() == bytes.readLong(0L);
    }

    @Override
    public long hash(LongValue e) {
        return Hasher.hash(e.getValue());
    }

    @Override
    public void write(Bytes bytes, LongValue e) {
        bytes.writeLong(e.getValue());
    }

    @Override
    public long readSize(Bytes bytes) {
        return 8L;
    }

    @Override
    public LongValue read(Bytes bytes, long size) {
        return this.read(bytes, size, (LongValue)DataValueClasses.newInstance(LongValue.class));
    }

    @Override
    public LongValue read(Bytes bytes, long size, LongValue toReuse) {
        toReuse.setValue(bytes.readLong());
        return toReuse;
    }
}

