/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.TcpReplicationConfig;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicationConfig;
import net.openhft.chronicle.map.UdpReplicator;

public final class Replicators {
    private Replicators() {
    }

    public static Replicator tcp(final byte identifier, final TcpReplicationConfig replicationConfig) {
        return new Replicator(){

            @Override
            public byte identifier() {
                return identifier;
            }

            @Override
            protected Closeable applyTo(ChronicleMapBuilder builder, Replica map, Replica.EntryExternalizable entryExternalizable) throws IOException {
                return new TcpReplicator(map, entryExternalizable, replicationConfig, builder.entrySize());
            }
        };
    }

    public static Replicator udp(final byte identifier, final UdpReplicationConfig replicationConfig) {
        return new Replicator(){

            @Override
            public byte identifier() {
                return identifier;
            }

            @Override
            protected Closeable applyTo(ChronicleMapBuilder builder, Replica map, Replica.EntryExternalizable entryExternalizable) throws IOException {
                return new UdpReplicator(map, entryExternalizable, replicationConfig, builder.entrySize());
            }
        };
    }
}

