/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.lang.io.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapEventListeners {
    static final MapEventListener NOP = new MapEventListener(){
        private static final long serialVersionUID = 0L;
    };
    private static final MapEventListener BYTES_LOGGING = new MapEventListener(){
        private static final long serialVersionUID = 0L;
        public final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

        public void onGetFound(ChronicleMap map, Bytes entry, int metaDataBytes, Object key, Object value) {
            this.logOperation(map, entry, metaDataBytes, " get ");
        }

        private void logOperation(ChronicleMap map, Bytes entry, int metaDataBytes, String oper) {
            StringBuilder sb = new StringBuilder();
            sb.append(map.file()).append(oper);
            if (metaDataBytes > 0) {
                sb.append("Meta: ");
                entry.toString((Appendable)sb, 0L, 0L, (long)metaDataBytes);
                sb.append(" | ");
            }
            Bytes slice = entry.slice((long)metaDataBytes, entry.limit() - (long)metaDataBytes);
            VanillaChronicleMap vanillaMap = (VanillaChronicleMap)map;
            long keySize = vanillaMap.keySizeMarshaller.readSize(slice);
            slice.toString((Appendable)sb, slice.position(), 0L, slice.position() + keySize);
            slice.position(slice.position() + keySize);
            long valueSize = vanillaMap.valueSizeMarshaller.readSize(slice);
            vanillaMap.alignment.alignPositionAddr(slice);
            sb.append(" = ");
            slice.toString((Appendable)sb, slice.position(), 0L, slice.position() + valueSize);
            this.LOGGER.info(sb.toString());
        }

        public void onPut(ChronicleMap map, Bytes entry, int metaDataBytes, boolean added, Object key, Object value, long pos, SharedSegment segment) {
            this.logOperation(map, entry, metaDataBytes, added ? " +put " : " put ");
        }

        public void onRemove(ChronicleMap map, Bytes entry, int metaDataBytes, Object key, Object value, int pos, SharedSegment segment) {
            this.logOperation(map, entry, metaDataBytes, " remove ");
        }
    };
    private static final MapEventListener KEY_VALUE_LOGGING = new MapEventListener(){
        private static final long serialVersionUID = 0L;
        public final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

        public void onGetFound(ChronicleMap map, Bytes entry, int metaDataBytes, Object key, Object value) {
            this.LOGGER.info("{} get {} => {}", new Object[]{map.file(), key, value});
        }

        public void onPut(ChronicleMap map, Bytes entry, int metaDataBytes, boolean added, Object key, Object value, long pos, SharedSegment segment) {
            this.LOGGER.info("{} put {} => {}", new Object[]{map.file(), key, value});
        }

        public void onRemove(ChronicleMap map, Bytes entry, int metaDataBytes, Object key, Object value, int pos, SharedSegment segment) {
            this.LOGGER.info("{} remove {} was {}", new Object[]{map.file(), key, value});
        }
    };

    private MapEventListeners() {
    }

    public static <K, V, M extends ChronicleMap<K, V>> MapEventListener<K, V, M> nop() {
        return NOP;
    }

    public static <K, V, M extends ChronicleMap<K, V>> MapEventListener<K, V, M> bytesLogging() {
        return BYTES_LOGGING;
    }

    public static <K, V, M extends ChronicleMap<K, V>> MapEventListener<K, V, M> keyValueLogging() {
        return KEY_VALUE_LOGGING;
    }
}

