/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.lang.io.Bytes;

public enum Alignment {
    NO_ALIGNMENT{

        @Override
        void alignPositionAddr(Bytes bytes) {
        }

        @Override
        long alignAddr(long addr) {
            return addr;
        }

        @Override
        int alignSize(int size) {
            return size;
        }
    }
    ,
    OF_4_BYTES{

        @Override
        void alignPositionAddr(Bytes bytes) {
            bytes.alignPositionAddr(4);
        }

        @Override
        long alignAddr(long addr) {
            return addr + 3L & 0xFFFFFFFFFFFFFFFCL;
        }

        @Override
        int alignSize(int size) {
            return size + 3 & 0xFFFFFFFC;
        }
    }
    ,
    OF_8_BYTES{

        @Override
        void alignPositionAddr(Bytes bytes) {
            bytes.alignPositionAddr(8);
        }

        @Override
        long alignAddr(long addr) {
            return addr + 7L & 0xFFFFFFFFFFFFFFF8L;
        }

        @Override
        int alignSize(int size) {
            return size + 7 & 0xFFFFFFF8;
        }
    };

    private static final Alignment[] VALUES;

    static Alignment fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    abstract void alignPositionAddr(Bytes var1);

    abstract long alignAddr(long var1);

    abstract int alignSize(int var1);

    static {
        VALUES = Alignment.values();
    }
}

