/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization;

import net.openhft.chronicle.map.threadlocal.StatefulCopyable;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;

final class DirectBytesBuffer
implements StatefulCopyable<DirectBytesBuffer> {
    private final Object identity;
    private DirectBytes buffer;

    DirectBytesBuffer(Object identity) {
        this.identity = identity;
    }

    private Bytes buffer(long maxSize) {
        DirectBytes buf = this.buffer;
        if (buf != null) {
            if (maxSize <= buf.capacity()) {
                return buf.clear();
            }
            DirectStore store = (DirectStore)buf.store();
            store.resize(maxSize, false);
            this.buffer = store.bytes();
            return this.buffer;
        }
        this.buffer = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, maxSize, false).bytes();
        return this.buffer;
    }

    @Override
    public Object stateIdentity() {
        return this.identity;
    }

    @Override
    public DirectBytesBuffer copy() {
        return new DirectBytesBuffer(this.identity);
    }
}

