/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CloseablesManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)CloseablesManager.class.getName());
    private boolean isClosed = false;
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    CloseablesManager() {
    }

    private void checkState() {
        if (this.isClosed) {
            throw new IllegalStateException();
        }
    }

    public synchronized void add(Closeable closeable) {
        this.checkState();
        if (closeable == null) {
            throw new NullPointerException();
        }
        this.closeables.add(closeable);
    }

    public synchronized void close(Closeable closeable) throws IOException {
        this.checkState();
        Iterator<Closeable> iterator = this.closeables.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != closeable) continue;
            iterator.remove();
        }
        closeable.close();
    }

    public synchronized void closeQuietly(Closeable closeable) {
        try {
            this.close(closeable);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException ex = null;
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                ex = e;
            }
        }
        this.closeables.clear();
        this.isClosed = true;
        if (ex != null) {
            throw ex;
        }
    }

    public synchronized void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }
}

