/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.collections;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.collections.Alignment;
import net.openhft.collections.IntIntMultiMap;
import net.openhft.collections.SharedHashMap;
import net.openhft.collections.SharedHashMapBuilder;
import net.openhft.collections.SharedMapErrorListener;
import net.openhft.collections.SharedMapEventListener;
import net.openhft.collections.SharedMapEventListeners;
import net.openhft.collections.SharedSegment;
import net.openhft.collections.VanillaIntIntMultiMap;
import net.openhft.collections.VanillaShortShortMultiMap;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVanillaSharedHashMap<K, V>
extends AbstractMap<K, V>
implements ChronicleMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVanillaSharedHashMap.class);
    private static final int MAX_ENTRY_OVERSIZE_FACTOR = 64;
    private final int bufferAllocationFactor;
    private final ThreadLocal<DirectBytes> localBufferForKeys = new ThreadLocal();
    private final ThreadLocal<DirectBytes> localBufferForValues = new ThreadLocal();
    final Class<K> kClass;
    final Class<V> vClass;
    private final long lockTimeOutNS;
    final int metaDataBytes;
    Segment[] segments;
    BytesStore ms;
    final Hasher hasher;
    final int entrySize;
    final Alignment alignment;
    final int entriesPerSegment;
    private final SharedMapErrorListener errorListener;
    volatile SharedMapEventListener<K, V, SharedHashMap<K, V>> eventListener;
    private final boolean generatedKeyType;
    final boolean generatedValueType;
    final boolean putReturnsNull;
    final boolean removeReturnsNull;
    transient Set<Map.Entry<K, V>> entrySet;

    private static int figureBufferAllocationFactor(SharedHashMapBuilder builder) {
        return (int)Math.min(Math.max(2L, builder.entries() >> 10), 64L);
    }

    public AbstractVanillaSharedHashMap(SharedHashMapBuilder builder, Class<K> kClass, Class<V> vClass) throws IOException {
        int entriesPerSegment;
        this.bufferAllocationFactor = AbstractVanillaSharedHashMap.figureBufferAllocationFactor(builder);
        this.kClass = kClass;
        this.vClass = vClass;
        this.lockTimeOutNS = builder.lockTimeOutMS() * 1000000L;
        this.entrySize = builder.alignedEntrySize();
        this.alignment = builder.entryAndValueAlignment();
        this.errorListener = builder.errorListener();
        this.generatedKeyType = builder.generatedKeyType();
        this.generatedValueType = builder.generatedValueType();
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        int segments = builder.actualSegments();
        this.entriesPerSegment = entriesPerSegment = builder.actualEntriesPerSegment();
        this.metaDataBytes = builder.metaDataBytes();
        this.eventListener = builder.eventListener();
        int hashMask = this.useSmallMultiMaps() ? 65535 : -1;
        this.hasher = new Hasher(segments, hashMask);
        Segment[] ss = (Segment[])Array.newInstance(this.segmentType(), segments);
        this.segments = ss;
    }

    Class segmentType() {
        return Segment.class;
    }

    long createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.onHeaderCreated();
        long offset = this.getHeaderSize();
        long segmentSize = this.segmentSize();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment((NativeBytes)this.ms.bytes(offset, segmentSize), i);
            offset += segmentSize;
        }
        return offset;
    }

    void onHeaderCreated() {
    }

    int getHeaderSize() {
        return 128;
    }

    Segment createSegment(NativeBytes bytes, int index) {
        return new Segment(bytes, index);
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    static int expectedStopBits(long size) {
        if (size <= 127L) {
            return 1;
        }
        return (70 - Long.numberOfLeadingZeros(size)) / 7;
    }

    long sizeInBytes() {
        return (long)this.getHeaderSize() + (long)this.segments.length * this.segmentSize();
    }

    long sizeOfMultiMap() {
        int np2 = Maths.nextPower2((int)this.entriesPerSegment, (int)8);
        return AbstractVanillaSharedHashMap.align64((long)np2 * (this.entriesPerSegment > 65536 ? 8L : 4L));
    }

    long sizeOfMultiMapBitSet(long numberOfBits) {
        long numberOfBytes = (numberOfBits + 7L) / 8L;
        return AbstractVanillaSharedHashMap.align64(numberOfBytes);
    }

    boolean useSmallMultiMaps() {
        return this.entriesPerSegment <= 65536;
    }

    long sizeOfBitSets() {
        return AbstractVanillaSharedHashMap.align64(this.entriesPerSegment / 8);
    }

    int numberOfBitSets() {
        return 1;
    }

    long segmentSize() {
        long sizeOfMultiMap = this.sizeOfMultiMap();
        long ss = 64L + (sizeOfMultiMap + this.sizeOfMultiMapBitSet(sizeOfMultiMap)) * (long)this.multiMapsPerSegment() + (long)this.numberOfBitSets() * this.sizeOfBitSets() + this.sizeOfEntriesInSegment();
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        if ((ss & 0xFFDL) < 64L) {
            ss = (ss & 0xFFFFFFFFFFFFFFC0L) + 64L;
        }
        return ss;
    }

    int multiMapsPerSegment() {
        return 1;
    }

    private long sizeOfEntriesInSegment() {
        return AbstractVanillaSharedHashMap.align64((long)this.entriesPerSegment * (long)this.entrySize);
    }

    static long align64(long l) {
        return l + 63L & 0xFFFFFFFFFFFFFFC0L;
    }

    @Override
    public void close() {
        if (this.ms == null) {
            return;
        }
        this.ms.free();
        this.segments = null;
        this.ms = null;
    }

    private DirectBytes acquireBufferForKey() {
        DirectBytes buffer = this.localBufferForKeys.get();
        if (buffer == null) {
            buffer = new DirectStore(this.ms.objectSerializer(), (long)(this.entrySize * this.bufferAllocationFactor), false).bytes();
            this.localBufferForKeys.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    private DirectBytes acquireBufferForValue() {
        DirectBytes buffer = this.localBufferForValues.get();
        if (buffer == null) {
            buffer = new DirectStore(this.ms.objectSerializer(), (long)(this.entrySize * this.bufferAllocationFactor), false).bytes();
            this.localBufferForValues.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    void checkValue(Object value) {
        if (!this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, true);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put0(key, value, false);
    }

    private V put0(K key, V value, boolean replaceIfPresent) {
        this.checkKey(key);
        this.checkValue(value);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segments[segmentNum].put((Bytes)keyBytes, key, value, segmentHash, replaceIfPresent);
    }

    DirectBytes getKeyAsBytes(K key) {
        DirectBytes buffer = this.acquireBufferForKey();
        if (this.generatedKeyType) {
            ((BytesMarshallable)key).writeMarshallable((Bytes)buffer);
        } else {
            buffer.writeInstance(this.kClass, key);
        }
        buffer.flip();
        return buffer;
    }

    DirectBytes getValueAsBytes(V value) {
        DirectBytes buffer = this.acquireBufferForValue();
        buffer.clear();
        if (this.generatedValueType) {
            ((BytesMarshallable)value).writeMarshallable((Bytes)buffer);
        } else {
            buffer.writeInstance(this.vClass, value);
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public V get(Object key) {
        return this.lookupUsing(key, null, false);
    }

    @Override
    public V getUsing(K key, V value) {
        return this.lookupUsing(key, value, false);
    }

    @Override
    public V acquireUsing(K key, V value) {
        return this.lookupUsing(key, value, true);
    }

    V lookupUsing(K key, V value, boolean create) {
        this.checkKey(key);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segments[segmentNum].acquire((Bytes)keyBytes, key, value, segmentHash, create);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segments[segmentNum].containsKey((Bytes)keyBytes, segmentHash);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public V remove(Object key) {
        return this.removeIfValueIs(key, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.removeIfValueIs(key, value) != null;
    }

    V removeIfValueIs(Object key, V expectedValue) {
        this.checkKey(key);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segments[segmentNum].remove((Bytes)keyBytes, key, expectedValue, segmentHash);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        return oldValue.equals(this.replaceIfValueIs(key, oldValue, newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.replaceIfValueIs(key, null, value);
    }

    @Override
    public long longSize() {
        long result = 0L;
        for (Segment segment : this.segments) {
            result += (long)segment.getSize();
        }
        return result;
    }

    @Override
    public int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    V replaceIfValueIs(@NotNull K key, V existingValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        DirectBytes keyBytes = this.getKeyAsBytes(key);
        long hash = Hasher.hash((Bytes)keyBytes);
        int segmentNum = this.hasher.getSegment(hash);
        int segmentHash = this.hasher.segmentHash(hash);
        return this.segments[segmentNum].replace((Bytes)keyBytes, key, existingValue, newValue, segmentHash);
    }

    void checkConsistency() {
        for (Segment segment : this.segments) {
            segment.checkConsistency();
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            AbstractVanillaSharedHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object v = AbstractVanillaSharedHashMap.this.get(e.getKey());
                return v != null && v.equals(e.getValue());
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object key = e.getKey();
                Object value = e.getValue();
                return AbstractVanillaSharedHashMap.this.remove(key, value);
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public int size() {
            return AbstractVanillaSharedHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AbstractVanillaSharedHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            AbstractVanillaSharedHashMap.this.clear();
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        boolean wasNextCalledSinceLastRemove = false;
        private int seg;
        private int pos;

        public EntryIterator() {
            int pos1 = -1;
            this.seg = AbstractVanillaSharedHashMap.this.segments.length - 1;
            this.pos = pos1;
        }

        @Override
        public synchronized boolean hasNext() {
            int pos = this.pos;
            int segIndex = this.seg;
            while (segIndex >= 0) {
                if (AbstractVanillaSharedHashMap.this.segments[segIndex].getHashLookup().getPositions().nextSetBit((long)(pos + 1)) != -1L) {
                    return true;
                }
                --segIndex;
                pos = -1;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            int pos = this.pos;
            int segIndex = this.seg;
            while (true) {
                if (segIndex < 0) {
                    throw new NoSuchElementException();
                }
                Segment segment = AbstractVanillaSharedHashMap.this.segments[segIndex];
                try {
                    segment.lock();
                    pos = (int)segment.getHashLookup().getPositions().nextSetBit((long)(pos + 1));
                    if (pos == -1) {
                        --segIndex;
                        pos = -1;
                        continue;
                    }
                    this.wasNextCalledSinceLastRemove = true;
                    this.seg = segIndex;
                    this.pos = pos;
                    Map.Entry entry = segment.getEntry(pos);
                    return entry;
                }
                finally {
                    segment.unlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (!this.wasNextCalledSinceLastRemove) {
                throw new IllegalStateException();
            }
            int pos = this.pos;
            int segIndex = this.seg;
            Segment segment = AbstractVanillaSharedHashMap.this.segments[segIndex];
            try {
                segment.lock();
                long offset = segment.offsetFromPos(pos);
                MultiStoreBytes entry = segment.entry(offset);
                long limit = entry.limit();
                long keyLen = entry.readStopBit();
                entry.limit(entry.position() + keyLen);
                int segmentHash = AbstractVanillaSharedHashMap.this.hasher.segmentHash(Hasher.hash((Bytes)entry));
                entry.limit(limit);
                long entryEndAddr = entry.positionAddr() + segment.readValueLen((Bytes)entry);
                segment.decrementSize();
                segment.free(pos, segment.inBlocks(entryEndAddr - segment.entryStartAddr(offset)));
                segment.getHashLookup().remove(segmentHash, pos);
                this.wasNextCalledSinceLastRemove = false;
            }
            finally {
                segment.unlock();
            }
        }
    }

    class Segment
    implements SharedSegment {
        static final int LOCK_OFFSET = 0;
        static final int SIZE_OFFSET = 8;
        static final int PAD1_OFFSET = 12;
        static final int REPLICA_OFFSET = 16;
        private final NativeBytes bytes;
        private final int index;
        final MultiStoreBytes tmpBytes = new MultiStoreBytes();
        private IntIntMultiMap hashLookup;
        private final SingleThreadedDirectBitSet freeList;
        private int nextPosToSearchFrom = 0;
        final long entriesOffset;

        Segment(NativeBytes bytes, int index) {
            this.bytes = bytes;
            this.index = index;
            long start = bytes.startAddr() + 64L;
            this.createHashLookups(start);
            long sizeOfMultiMap = AbstractVanillaSharedHashMap.this.sizeOfMultiMap();
            NativeBytes bsBytes = new NativeBytes(this.tmpBytes.objectSerializer(), start += (sizeOfMultiMap + AbstractVanillaSharedHashMap.this.sizeOfMultiMapBitSet(sizeOfMultiMap)) * (long)AbstractVanillaSharedHashMap.this.multiMapsPerSegment(), start + AbstractVanillaSharedHashMap.this.sizeOfBitSets(), null);
            this.freeList = new SingleThreadedDirectBitSet((Bytes)bsBytes);
            this.entriesOffset = (start += (long)AbstractVanillaSharedHashMap.this.numberOfBitSets() * AbstractVanillaSharedHashMap.this.sizeOfBitSets()) - bytes.startAddr();
            assert (bytes.capacity() >= this.entriesOffset + (long)(AbstractVanillaSharedHashMap.this.entriesPerSegment * AbstractVanillaSharedHashMap.this.entrySize));
        }

        void createHashLookups(long start) {
            this.hashLookup = this.createMultiMap(start);
        }

        public IntIntMultiMap getHashLookup() {
            return this.hashLookup;
        }

        IntIntMultiMap createMultiMap(long start) {
            long sizeOfMultiMap = AbstractVanillaSharedHashMap.this.sizeOfMultiMap();
            NativeBytes multiMapBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start += sizeOfMultiMap, null);
            NativeBytes sizeOfMultiMapBitSetBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start + AbstractVanillaSharedHashMap.this.sizeOfMultiMapBitSet(sizeOfMultiMap), null);
            multiMapBytes.load();
            return AbstractVanillaSharedHashMap.this.useSmallMultiMaps() ? new VanillaShortShortMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes) : new VanillaIntIntMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes);
        }

        public int getIndex() {
            return this.index;
        }

        void incrementSize() {
            this.bytes.addInt(8L, 1);
        }

        void resetSize() {
            this.bytes.writeInt(8L, 0);
        }

        void decrementSize() {
            this.bytes.addInt(8L, -1);
        }

        int getSize() {
            return Math.max(0, this.bytes.readVolatileInt(8L));
        }

        public void lock() throws IllegalStateException {
            boolean success;
            while (!(success = this.bytes.tryLockNanosLong(0L, AbstractVanillaSharedHashMap.this.lockTimeOutNS))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                AbstractVanillaSharedHashMap.this.errorListener.onLockTimeout(this.bytes.threadIdForLockLong(0L));
                this.bytes.resetLockLong(0L);
            }
            return;
        }

        public void unlock() {
            try {
                this.bytes.unlockLong(0L);
            }
            catch (IllegalMonitorStateException e) {
                AbstractVanillaSharedHashMap.this.errorListener.errorOnUnlock(e);
            }
        }

        public long offsetFromPos(long pos) {
            return this.entriesOffset + pos * (long)AbstractVanillaSharedHashMap.this.entrySize;
        }

        long posFromOffset(long offset) {
            return (offset - this.entriesOffset) / (long)AbstractVanillaSharedHashMap.this.entrySize;
        }

        public MultiStoreBytes entry(long offset) {
            return this.reuse(this.tmpBytes, offset);
        }

        private MultiStoreBytes reuse(MultiStoreBytes entry, long offset) {
            entry.storePositionAndSize((BytesStore)this.bytes, offset += (long)AbstractVanillaSharedHashMap.this.metaDataBytes, this.bytes.limit() - offset);
            return entry;
        }

        long entryStartAddr(long offset) {
            return this.bytes.startAddr() + offset;
        }

        private long entrySize(long keyLen, long valueLen) {
            return AbstractVanillaSharedHashMap.this.alignment.alignAddr((long)(AbstractVanillaSharedHashMap.this.metaDataBytes + AbstractVanillaSharedHashMap.expectedStopBits(keyLen)) + keyLen + (long)AbstractVanillaSharedHashMap.expectedStopBits(valueLen)) + valueLen;
        }

        int inBlocks(long sizeInBytes) {
            if (sizeInBytes <= (long)AbstractVanillaSharedHashMap.this.entrySize) {
                return 1;
            }
            if (--sizeInBytes <= Integer.MAX_VALUE) {
                return (int)sizeInBytes / AbstractVanillaSharedHashMap.this.entrySize + 1;
            }
            return (int)(sizeInBytes / (long)AbstractVanillaSharedHashMap.this.entrySize) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V acquire(Bytes keyBytes, K key, V usingValue, int hash2, boolean create) {
            this.lock();
            try {
                MultiStoreBytes entry = this.tmpBytes;
                long offset = this.searchKey(keyBytes, hash2, entry, this.hashLookup);
                if (offset >= 0L) {
                    Object v = this.onKeyPresentOnAcquire(key, usingValue, offset, (NativeBytes)entry);
                    return v;
                }
                if ((usingValue = this.tryObtainUsingValueOnAcquire(keyBytes, key, usingValue, create)) != null) {
                    offset = this.putEntry(keyBytes, usingValue, create);
                    this.incrementSize();
                    this.notifyPut(offset, true, key, usingValue, this.posFromOffset(offset));
                    Object v = usingValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        long searchKey(Bytes keyBytes, int hash2, MultiStoreBytes entry, IntIntMultiMap hashLookup) {
            int pos;
            long keyLen = keyBytes.remaining();
            hashLookup.startSearch(hash2);
            while ((pos = hashLookup.nextPos()) >= 0) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                entry.skip(keyLen);
                return offset;
            }
            return -1L;
        }

        V onKeyPresentOnAcquire(K key, V usingValue, long offset, NativeBytes entry) {
            Object v = this.readValue(entry, usingValue);
            this.notifyGet(offset, key, v);
            return v;
        }

        V tryObtainUsingValueOnAcquire(Bytes keyBytes, K key, V usingValue, boolean create) {
            if (create) {
                if (usingValue != null) {
                    return usingValue;
                }
                if (AbstractVanillaSharedHashMap.this.generatedValueType) {
                    return DataValueClasses.newDirectReference(AbstractVanillaSharedHashMap.this.vClass);
                }
                try {
                    return AbstractVanillaSharedHashMap.this.vClass.newInstance();
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (usingValue instanceof Byteable) {
                ((Byteable)usingValue).bytes(null, 0L);
            }
            return this.notifyMissed(keyBytes, key, usingValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(Bytes keyBytes, K key, V value, int hash2, boolean replaceIfPresent) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    if (replaceIfPresent) {
                        Object v = this.replaceValueOnPut(key, value, (NativeBytes)entry, pos, offset, !AbstractVanillaSharedHashMap.this.putReturnsNull, this.hashLookup);
                        return v;
                    }
                    Object v = AbstractVanillaSharedHashMap.this.putReturnsNull ? null : (Object)this.readValue((NativeBytes)entry, null);
                    return v;
                }
                long offset = this.putEntry(keyBytes, value, false);
                this.incrementSize();
                this.notifyPut(offset, true, key, value, this.posFromOffset(offset));
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V replaceValueOnPut(K key, V value, NativeBytes entry, int pos, long offset, boolean readPrevValue, IntIntMultiMap searchedHashLookup) {
            long valueLenPos = entry.position();
            long valueLen = this.readValueLen((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueLen;
            Object prevValue = null;
            if (readPrevValue) {
                prevValue = this.readValue(entry, null, valueLen);
            }
            offset = this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, value, searchedHashLookup);
            this.notifyPut(offset, false, key, value, this.posFromOffset(offset));
            return prevValue;
        }

        private long putEntry(Bytes keyBytes, V value, boolean usingValue) {
            long valueLen;
            long keyLen = keyBytes.remaining();
            boolean byteableValue = usingValue && value instanceof Byteable;
            DirectBytes valueBytes = null;
            Byteable valueAsByteable = null;
            if (!byteableValue) {
                valueBytes = AbstractVanillaSharedHashMap.this.getValueAsBytes(value);
                valueLen = valueBytes.remaining();
            } else {
                valueAsByteable = (Byteable)value;
                valueLen = valueAsByteable.maxSize();
            }
            long entrySize = this.entrySize(keyLen, valueLen);
            int pos = this.alloc(this.inBlocks(entrySize));
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            MultiStoreBytes entry = this.entry(offset);
            entry.writeStopBit(keyLen);
            entry.write((RandomDataInput)keyBytes);
            this.writeValueOnPutEntry(valueLen, (Bytes)valueBytes, valueAsByteable, (NativeBytes)entry);
            this.hashLookup.putAfterFailedSearch(pos);
            return offset;
        }

        void writeValueOnPutEntry(long valueLen, @Nullable Bytes valueBytes, @Nullable Byteable valueAsByteable, NativeBytes entry) {
            entry.writeStopBit(valueLen);
            AbstractVanillaSharedHashMap.this.alignment.alignPositionAddr((Bytes)entry);
            if (valueBytes != null) {
                entry.write((RandomDataInput)valueBytes);
            } else {
                assert (valueAsByteable != null);
                long valueOffset = entry.positionAddr() - this.bytes.address();
                this.bytes.zeroOut(valueOffset, valueOffset + valueLen);
                valueAsByteable.bytes((Bytes)this.bytes, valueOffset);
            }
        }

        void clearMetaData(long offset) {
            if (AbstractVanillaSharedHashMap.this.metaDataBytes > 0) {
                this.bytes.zeroOut(offset, offset + (long)AbstractVanillaSharedHashMap.this.metaDataBytes);
            }
        }

        int alloc(int blocks) {
            int ret = (int)this.freeList.setNextNContinuousClearBits((long)this.nextPosToSearchFrom, blocks);
            if ((long)ret == -1L && (long)(ret = (int)this.freeList.setNextNContinuousClearBits(0L, blocks)) == -1L) {
                if (blocks == 1) {
                    throw new IllegalArgumentException("Segment is full, no free entries found");
                }
                throw new IllegalArgumentException("Segment is full or has no ranges of " + blocks + " continuous free blocks");
            }
            if (blocks == 1 || this.freeList.isSet((long)this.nextPosToSearchFrom)) {
                this.nextPosToSearchFrom = ret + blocks;
            }
            return ret;
        }

        private boolean realloc(int fromPos, int oldBlocks, int newBlocks) {
            if (this.freeList.allClear((long)(fromPos + oldBlocks), (long)(fromPos + newBlocks))) {
                this.freeList.set((long)(fromPos + oldBlocks), (long)(fromPos + newBlocks));
                return true;
            }
            return false;
        }

        void free(int fromPos, int blocks) {
            this.freeList.clear((long)fromPos, (long)(fromPos + blocks));
            if (fromPos < this.nextPosToSearchFrom) {
                this.nextPosToSearchFrom = fromPos;
            }
        }

        V readValue(NativeBytes entry, V value) {
            return this.readValue(entry, value, this.readValueLen((Bytes)entry));
        }

        long readValueLen(Bytes entry) {
            long valueLen = entry.readStopBit();
            AbstractVanillaSharedHashMap.this.alignment.alignPositionAddr(entry);
            return valueLen;
        }

        V readValue(NativeBytes entry, V value, long valueLen) {
            if (AbstractVanillaSharedHashMap.this.generatedValueType) {
                if (value == null) {
                    value = DataValueClasses.newDirectReference(AbstractVanillaSharedHashMap.this.vClass);
                } else assert (value instanceof Byteable);
            }
            if (value instanceof Byteable) {
                long valueOffset = entry.positionAddr() - this.bytes.address();
                ((Byteable)value).bytes((Bytes)this.bytes, valueOffset);
                return value;
            }
            return entry.readInstance(AbstractVanillaSharedHashMap.this.vClass, value);
        }

        boolean keyEquals(Bytes keyBytes, long keyLen, Bytes entry) {
            return keyLen == entry.readStopBit() && entry.startsWith((RandomDataInput)keyBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Bytes keyBytes, K key, V expectedValue, int hash2) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    Object valueRemoved;
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    long valueLen = this.readValueLen((Bytes)entry);
                    long entryEndAddr = entry.positionAddr() + valueLen;
                    Object v = valueRemoved = expectedValue != null || !AbstractVanillaSharedHashMap.this.removeReturnsNull ? (Object)this.readValue((NativeBytes)entry, null, valueLen) : null;
                    if (expectedValue != null && !expectedValue.equals(valueRemoved)) {
                        Object v2 = null;
                        return v2;
                    }
                    this.hashLookup.remove(this.hashLookup.getSearchHash(), pos);
                    this.decrementSize();
                    this.free(pos, this.inBlocks(entryEndAddr - this.entryStartAddr(offset)));
                    this.notifyRemoved(offset, key, valueRemoved, pos);
                    Object v3 = valueRemoved;
                    return v3;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(Bytes keyBytes, int hash2) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                IntIntMultiMap hashLookup = this.containsKeyHashLookup();
                hashLookup.startSearch(hash2);
                while ((pos = hashLookup.nextPos()) >= 0) {
                    MultiStoreBytes entry = this.entry(this.offsetFromPos(pos));
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        IntIntMultiMap containsKeyHashLookup() {
            return this.hashLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(Bytes keyBytes, K key, V expectedValue, V newValue, int hash2) {
            this.lock();
            try {
                int pos;
                long keyLen = keyBytes.remaining();
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyBytes, keyLen, (Bytes)entry)) continue;
                    entry.skip(keyLen);
                    Object v = this.onKeyPresentOnReplace(key, expectedValue, newValue, pos, offset, (NativeBytes)entry, this.hashLookup);
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V onKeyPresentOnReplace(K key, V expectedValue, V newValue, int pos, long offset, NativeBytes entry, IntIntMultiMap searchedHashLookup) {
            long valueLenPos = entry.position();
            long valueLen = this.readValueLen((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueLen;
            Object valueRead = this.readValue(entry, null, valueLen);
            if (valueRead == null) {
                return null;
            }
            if (expectedValue == null || expectedValue.equals(valueRead)) {
                offset = this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, newValue, searchedHashLookup);
                this.notifyPut(offset, false, key, newValue, this.posFromOffset(offset));
                return valueRead;
            }
            return null;
        }

        void notifyPut(long offset, boolean added, K key, V value, long pos) {
            if (AbstractVanillaSharedHashMap.this.eventListener != SharedMapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)AbstractVanillaSharedHashMap.this.entrySize);
                AbstractVanillaSharedHashMap.this.eventListener.onPut((SharedHashMap)AbstractVanillaSharedHashMap.this, (Bytes)this.tmpBytes, AbstractVanillaSharedHashMap.this.metaDataBytes, added, key, value, pos, (SharedSegment)this);
            }
        }

        void notifyGet(long offset, K key, V value) {
            if (AbstractVanillaSharedHashMap.this.eventListener != SharedMapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)AbstractVanillaSharedHashMap.this.entrySize);
                AbstractVanillaSharedHashMap.this.eventListener.onGetFound((SharedHashMap)AbstractVanillaSharedHashMap.this, (Bytes)this.tmpBytes, AbstractVanillaSharedHashMap.this.metaDataBytes, key, value);
            }
        }

        V notifyMissed(Bytes keyBytes, K key, V usingValue) {
            if (AbstractVanillaSharedHashMap.this.eventListener != SharedMapEventListeners.NOP) {
                return AbstractVanillaSharedHashMap.this.eventListener.onGetMissing((SharedHashMap)AbstractVanillaSharedHashMap.this, keyBytes, key, usingValue);
            }
            return null;
        }

        void notifyRemoved(long offset, K key, V value, int pos) {
            if (AbstractVanillaSharedHashMap.this.eventListener != SharedMapEventListeners.NOP) {
                this.tmpBytes.storePositionAndSize((BytesStore)this.bytes, offset, (long)AbstractVanillaSharedHashMap.this.entrySize);
                AbstractVanillaSharedHashMap.this.eventListener.onRemove((SharedHashMap)AbstractVanillaSharedHashMap.this, (Bytes)this.tmpBytes, AbstractVanillaSharedHashMap.this.metaDataBytes, key, value, pos, (SharedSegment)this);
            }
        }

        long putValue(int pos, long offset, NativeBytes entry, long valueLenPos, long entryEndAddr, V value, IntIntMultiMap searchedHashLookup) {
            if (value instanceof Byteable) {
                return this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, null, (Byteable)value, false, searchedHashLookup);
            }
            return this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, (Bytes)AbstractVanillaSharedHashMap.this.getValueAsBytes(value), null, true, searchedHashLookup);
        }

        long putValue(int pos, long offset, NativeBytes entry, long valueLenPos, long entryEndAddr, @Nullable Bytes valueBytes, @Nullable Byteable valueAsByteable, boolean allowOversize, IntIntMultiMap searchedHashLookup) {
            long newValueLen;
            long valueLenAddr = entry.address() + valueLenPos;
            if (valueBytes != null) {
                newValueLen = valueBytes.remaining();
            } else {
                assert (valueAsByteable != null);
                newValueLen = valueAsByteable.maxSize();
            }
            long newValueAddr = AbstractVanillaSharedHashMap.this.alignment.alignAddr(valueLenAddr + (long)AbstractVanillaSharedHashMap.expectedStopBits(newValueLen));
            long newEntryEndAddr = newValueAddr + newValueLen;
            if (newEntryEndAddr != entryEndAddr) {
                long entryStartAddr = this.entryStartAddr(offset);
                long oldEntrySize = entryEndAddr - entryStartAddr;
                int oldSizeInBlocks = this.inBlocks(oldEntrySize);
                int newSizeInBlocks = this.inBlocks(newEntryEndAddr - entryStartAddr);
                if (newSizeInBlocks > oldSizeInBlocks) {
                    if (!allowOversize && oldSizeInBlocks == 1) {
                        if (valueAsByteable != null) {
                            return this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, (Bytes)AbstractVanillaSharedHashMap.this.getValueAsBytes(valueAsByteable), null, false, searchedHashLookup);
                        }
                        throw new IllegalArgumentException("Byteable value is not allowed to make the entry oversized while it was not initially.");
                    }
                    if (newSizeInBlocks > 64) {
                        if (valueAsByteable != null) {
                            return this.putValue(pos, offset, entry, valueLenPos, entryEndAddr, (Bytes)AbstractVanillaSharedHashMap.this.getValueAsBytes(valueAsByteable), null, false, searchedHashLookup);
                        }
                        throw new IllegalArgumentException("Value too large: entry takes " + newSizeInBlocks + " blocks, " + 64 + " is maximum.");
                    }
                    if (!this.realloc(pos, oldSizeInBlocks, newSizeInBlocks)) {
                        this.free(pos, oldSizeInBlocks);
                        AbstractVanillaSharedHashMap.this.eventListener.onRelocation(pos, (SharedSegment)this);
                        int prevPos = pos;
                        pos = this.alloc(newSizeInBlocks);
                        this.replacePosInHashLookupOnRelocation(searchedHashLookup, prevPos, pos);
                        offset = this.offsetFromPos(pos);
                        long newEntryStartAddr = this.entryStartAddr(offset);
                        NativeBytes.UNSAFE.copyMemory(entryStartAddr, newEntryStartAddr, valueLenAddr - entryStartAddr);
                        entry = this.entry(offset);
                    }
                } else if (newSizeInBlocks < oldSizeInBlocks) {
                    this.freeList.clear((long)(pos + newSizeInBlocks), (long)(pos + oldSizeInBlocks));
                }
            }
            entry.position(valueLenPos);
            entry.writeStopBit(newValueLen);
            AbstractVanillaSharedHashMap.this.alignment.alignPositionAddr((Bytes)entry);
            if (valueBytes != null) {
                entry.write((RandomDataInput)valueBytes);
            } else if (valueAsByteable instanceof BytesMarshallable) {
                long posAddr = entry.positionAddr();
                ((BytesMarshallable)valueAsByteable).writeMarshallable((Bytes)entry);
                long actualValueLen = entry.positionAddr() - posAddr;
                if (actualValueLen > newValueLen) {
                    throw new AssertionError((Object)"Byteable value returned maxSize less than the actual size");
                }
            } else {
                entry.write((RandomDataInput)valueAsByteable.bytes(), valueAsByteable.offset(), newValueLen);
            }
            return offset;
        }

        void replacePosInHashLookupOnRelocation(IntIntMultiMap searchedHashLookup, int prevPos, int pos) {
            searchedHashLookup.replacePrevPos(pos);
        }

        void clear() {
            this.lock();
            try {
                this.hashLookup.clear();
                this.freeList.clear();
                this.resetSize();
            }
            finally {
                this.unlock();
            }
        }

        void visit(IntIntMultiMap.EntryConsumer entryConsumer) {
            this.hashLookup.forEach(entryConsumer);
        }

        public Map.Entry<K, V> getEntry(long pos) {
            long offset = this.offsetFromPos(pos);
            MultiStoreBytes entry = this.entry(offset);
            entry.readStopBit();
            Object key = entry.readInstance(AbstractVanillaSharedHashMap.this.kClass, null);
            Object value = this.readValue((NativeBytes)entry, null);
            return new WriteThroughEntry(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkConsistency() {
            this.lock();
            try {
                IntIntMultiMap hashLookup = this.checkConsistencyHashLookup();
                int pos = 0;
                while ((pos = (int)this.freeList.nextSetBit((long)pos)) >= 0) {
                    PosPresentOnce check = new PosPresentOnce(pos);
                    hashLookup.forEach((IntIntMultiMap.EntryConsumer)check);
                    if (check.count != 1) {
                        throw new AssertionError();
                    }
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    long keyLen = entry.readStopBit();
                    entry.skip(keyLen);
                    this.afterKeyHookOnCheckConsistency((Bytes)entry);
                    long valueLen = entry.readStopBit();
                    long sizeInBytes = this.entrySize(keyLen, valueLen);
                    int entrySizeInBlocks = this.inBlocks(sizeInBytes);
                    if (!this.freeList.allSet((long)pos, (long)(pos + entrySizeInBlocks))) {
                        throw new AssertionError();
                    }
                    pos += entrySizeInBlocks;
                }
            }
            finally {
                this.unlock();
            }
        }

        void afterKeyHookOnCheckConsistency(Bytes entry) {
        }

        IntIntMultiMap checkConsistencyHashLookup() {
            return this.hashLookup;
        }

        private class PosPresentOnce
        implements IntIntMultiMap.EntryConsumer {
            int pos;
            int count = 0;

            PosPresentOnce(int pos) {
                this.pos = pos;
            }

            public void accept(int hash, int pos) {
                if (this.pos == pos) {
                    ++this.count;
                }
            }
        }
    }

    static final class Hasher {
        private final int segments;
        private final int bits;
        private final int mask;

        static long hash(Bytes bytes) {
            long i;
            long h = 0L;
            long limit = bytes.limit();
            for (i = bytes.position(); i < limit - 7L; i += 8L) {
                h = 1011001110001111L * h + bytes.readLong(i);
            }
            while (i < limit - 1L) {
                h = 101111L * h + (long)bytes.readShort(i);
                i += 2L;
            }
            if (i < limit) {
                h = 2111L * h + (long)bytes.readByte(i);
            }
            h *= 11018881818881011L;
            h ^= h >>> 41 ^ h >>> 21;
            return h;
        }

        Hasher(int segments, int mask) {
            this.segments = segments;
            this.bits = Maths.intLog2((long)segments);
            this.mask = mask;
        }

        int segmentHash(long hash) {
            return (int)(hash >>> this.bits) & this.mask;
        }

        int getSegment(long hash) {
            return (int)(hash & (long)(this.segments - 1));
        }
    }
}

