/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.openhft.lang.io.ByteStringAppender;

public class TimeStampFormatter {
    private static final ReferenceQueue<TimeStampFormatter> refQueue = new ReferenceQueue();
    private static final Map<String, FormatterReference> formatters = new HashMap<String, FormatterReference>();
    private static final FieldPosition unusedFieldPosition = new FieldPosition(0);
    private final MutablesCache mutablesCache;

    public static synchronized TimeStampFormatter fromDateFormat(String dateFormat) {
        TimeStampFormatter formatter;
        FormatterReference ref = formatters.get(dateFormat);
        if (ref == null || (formatter = (TimeStampFormatter)ref.get()) == null) {
            formatter = new TimeStampFormatter(dateFormat);
            formatters.put(dateFormat, new FormatterReference(dateFormat, formatter));
        }
        TimeStampFormatter.expungeStaleEntriesFromFormatters();
        return formatter;
    }

    private static void expungeStaleEntriesFromFormatters() {
        Reference<TimeStampFormatter> r;
        while ((r = refQueue.poll()) != null) {
            FormatterReference staleRef = (FormatterReference)r;
            FormatterReference removedRef = formatters.remove(staleRef.dateFormat);
            if (removedRef == staleRef) continue;
            formatters.put(removedRef.dateFormat, removedRef);
        }
    }

    private TimeStampFormatter(String dateFormat) {
        this.mutablesCache = new MutablesCache(dateFormat);
    }

    public void format(long timeStamp, ByteStringAppender appender) {
        Mutables ms = (Mutables)this.mutablesCache.get();
        StringBuffer sb = ms.sb;
        sb.setLength(0);
        Date date = ms.date;
        date.setTime(timeStamp);
        ms.format.format(date, sb, unusedFieldPosition);
        appender.append((CharSequence)sb);
    }

    public String format(long timeStamp) {
        Mutables ms = (Mutables)this.mutablesCache.get();
        StringBuffer sb = ms.sb;
        sb.setLength(0);
        Date date = ms.date;
        date.setTime(timeStamp);
        ms.format.format(date, sb, unusedFieldPosition);
        return sb.toString();
    }

    private static class MutablesCache
    extends ThreadLocal<Mutables> {
        private final String dateFormat;

        private MutablesCache(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        protected Mutables initialValue() {
            return new Mutables(this.dateFormat);
        }
    }

    private static class Mutables {
        final StringBuffer sb = new StringBuffer();
        final DateFormat format;
        final Date date = new Date();

        private Mutables(String dateFormat) {
            this.format = new SimpleDateFormat(dateFormat);
        }
    }

    private static class FormatterReference
    extends WeakReference<TimeStampFormatter> {
        private final String dateFormat;

        public FormatterReference(String dateFormat, TimeStampFormatter formatter) {
            super(formatter, refQueue);
            this.dateFormat = dateFormat;
        }
    }
}

