/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.BinaryChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.TextChronicleLogEvent;
import net.openhft.lang.io.Bytes;

public final class ChronicleLogHelper {
    public static ChronicleLogEvent decodeBinary(Bytes in) {
        return BinaryChronicleLogEvent.read(in);
    }

    public static ChronicleLogEvent decodeText(Bytes in) {
        return TextChronicleLogEvent.read(in);
    }

    public static ExcerptAppender appendStackTraceAsString(ExcerptAppender appender, Throwable throwable, String separator, int depth) {
        StackTraceElement[] elements = throwable.getStackTrace();
        int nbElements = depth == -1 ? elements.length : Math.min(depth, elements.length);
        int sepLen = separator.length();
        String tmp = null;
        appender.append((CharSequence)throwable.toString());
        if (nbElements > 0) {
            appender.append((CharSequence)separator);
        }
        for (int i = 0; i < nbElements; ++i) {
            tmp = elements[i].toString();
            if (appender.remaining() > (long)(tmp.length() + sepLen)) {
                appender.append((CharSequence)tmp);
                appender.append((CharSequence)separator);
                continue;
            }
            for (int fill = 0; fill < 3 && appender.remaining() > 0L; ++fill) {
                appender.append('.');
            }
            break;
        }
        return appender;
    }

    private ChronicleLogHelper() {
    }
}

