/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.IndexedLogAppenderConfig;
import net.openhft.chronicle.logger.VanillaLogAppenderConfig;

public class ChronicleLogConfig {
    public static final String KEY_PROPERTIES_FILE = "chronicle.logger.properties";
    public static final String KEY_PREFIX = "chronicle.logger.";
    public static final String KEY_PREFIX_ROOT = "chronicle.logger.root.";
    public static final String KEY_CFG_PREFIX = "chronicle.logger.root.cfg.";
    public static final String KEY_CHRONICLE_TYPE = "chronicle.logger.root.type";
    public static final String KEY_LEVEL = "level";
    public static final String KEY_PATH = "path";
    public static final String KEY_SHORTNAME = "shortName";
    public static final String KEY_APPEND = "append";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_TYPE = "type";
    public static final String KEY_DATE_FORMAT = "dateFormat";
    public static final String KEY_STACK_TRACE_DEPTH = "stackTraceDepth";
    public static final String FORMAT_BINARY = "binary";
    public static final String FORMAT_TEXT = "text";
    public static final String TYPE_VANILLA = "vanilla";
    public static final String TYPE_INDEXED = "indexed";
    public static final String BINARY_MODE_FORMATTED = "formatted";
    public static final String BINARY_MODE_SERIALIZED = "serialized";
    public static final String PLACEHOLDER_START = "${";
    public static final String PLACEHOLDER_END = "}";
    public static final String PLACEHOLDER_TODAY = "${today}";
    public static final String PLACEHOLDER_TODAY_FORMAT = "yyyyMMdd";
    public static final String PLACEHOLDER_PID = "${pid}";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd-HH:mm:ss.SSS";
    public static final List<String> DEFAULT_CFG_LOCATIONS = Arrays.asList("chronicle-logger.properties", "config/chronicle-logger.properties");
    public static final List<String> PACKAGE_MASK = Arrays.asList("net.openhft");
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    private final Properties properties;
    private final IndexedLogAppenderConfig indexedConfig;
    private final VanillaLogAppenderConfig vanillaConfig;

    private ChronicleLogConfig(Properties properties, IndexedLogAppenderConfig indexedConfig, VanillaLogAppenderConfig vanillaConfig) {
        this.properties = properties;
        this.indexedConfig = indexedConfig;
        this.vanillaConfig = vanillaConfig;
    }

    public static ChronicleLogConfig load(Properties properties) {
        return new ChronicleLogConfig(properties, ChronicleLogConfig.loadIndexedConfig(properties), ChronicleLogConfig.loadVanillaConfig(properties));
    }

    public static ChronicleLogConfig load(String cfgPath) {
        try {
            return ChronicleLogConfig.load(ChronicleLogConfig.getConfigurationStream(cfgPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ChronicleLogConfig load(InputStream in) {
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.load(in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ChronicleLogConfig.interpolate(properties);
            return ChronicleLogConfig.load(properties);
        }
        System.err.printf("Unable to configure chronicle-logger: configuration file not found in default locations (%s) or System property (%s) is not defined \n", DEFAULT_CFG_LOCATIONS.toString(), KEY_PROPERTIES_FILE);
        return null;
    }

    public static ChronicleLogConfig load() {
        try {
            InputStream is = ChronicleLogConfig.getConfigurationStream(System.getProperty(KEY_PROPERTIES_FILE));
            if (is == null) {
                String location;
                Iterator<String> i$ = DEFAULT_CFG_LOCATIONS.iterator();
                while (i$.hasNext() && (is = ChronicleLogConfig.getConfigurationStream(location = i$.next())) == null) {
                }
            }
            if (is != null) {
                return ChronicleLogConfig.load(is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static InputStream getConfigurationStream(String cfgPath) throws IOException {
        if (cfgPath != null) {
            File cfgFile = new File(cfgPath);
            if (!cfgFile.exists()) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(cfgPath);
            }
            if (cfgFile.canRead()) {
                return new FileInputStream(cfgFile);
            }
        }
        return null;
    }

    private static Properties interpolate(Properties tmpProperties) {
        int amended = 0;
        do {
            amended = 0;
            for (Map.Entry<Object, Object> entries : tmpProperties.entrySet()) {
                String val = tmpProperties.getProperty((String)entries.getKey());
                val = val.replace(PLACEHOLDER_TODAY, DATEFORMAT.format(new Date()));
                val = val.replace(PLACEHOLDER_PID, PID);
                int startIndex = 0;
                int endIndex = 0;
                do {
                    if ((startIndex = val.indexOf(PLACEHOLDER_START, endIndex)) == -1 || (endIndex = val.indexOf(PLACEHOLDER_END, startIndex)) == -1) continue;
                    String envKey = val.substring(startIndex + 2, endIndex);
                    String newVal = null;
                    if (tmpProperties.containsKey(envKey)) {
                        newVal = tmpProperties.getProperty(envKey);
                    } else if (System.getProperties().containsKey(envKey)) {
                        newVal = System.getProperties().getProperty(envKey);
                    }
                    if (newVal == null) continue;
                    val = val.replace(PLACEHOLDER_START + envKey + PLACEHOLDER_END, newVal);
                    endIndex += newVal.length() - envKey.length() + 3;
                    ++amended;
                } while (startIndex != -1 && endIndex != -1 && endIndex < val.length());
                entries.setValue(val);
            }
        } while (amended > 0);
        return tmpProperties;
    }

    private static IndexedLogAppenderConfig loadIndexedConfig(Properties properties) {
        if (!TYPE_INDEXED.equalsIgnoreCase(properties.getProperty(KEY_CHRONICLE_TYPE))) {
            return null;
        }
        IndexedLogAppenderConfig cfg = new IndexedLogAppenderConfig();
        cfg.setProperties(properties, KEY_CFG_PREFIX);
        return cfg;
    }

    private static VanillaLogAppenderConfig loadVanillaConfig(Properties properties) {
        if (!TYPE_VANILLA.equalsIgnoreCase(properties.getProperty(KEY_CHRONICLE_TYPE))) {
            return null;
        }
        VanillaLogAppenderConfig cfg = new VanillaLogAppenderConfig();
        cfg.setProperties(properties, KEY_CFG_PREFIX);
        return cfg;
    }

    public IndexedLogAppenderConfig getIndexedChronicleConfig() {
        return this.indexedConfig;
    }

    public VanillaLogAppenderConfig getVanillaChronicleConfig() {
        return this.vanillaConfig;
    }

    public String getString(String loggerName) {
        String name = KEY_PREFIX_ROOT + loggerName;
        return this.properties.getProperty(name);
    }

    public String getString(String loggerName, String shortName) {
        String key = KEY_PREFIX + loggerName + "." + shortName;
        String val = this.properties.getProperty(key);
        if (val == null) {
            val = this.getString(shortName);
        }
        return val;
    }

    public Boolean getBoolean(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Boolean.valueOf("true".equalsIgnoreCase(prop)) : null;
    }

    public Boolean getBoolean(String shortName, boolean defval) {
        String prop = this.getString(shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Boolean getBoolean(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Boolean.valueOf("true".equalsIgnoreCase(prop)) : null;
    }

    public Boolean getBoolean(String loggerName, String shortName, boolean defval) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Integer getInteger(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Integer getInteger(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Long getLong(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public Long getLong(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public Double getDouble(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Double.valueOf(Double.parseDouble(prop)) : null;
    }

    public Double getDouble(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Double.valueOf(Double.parseDouble(prop)) : null;
    }

    public Short getShort(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Short.valueOf(Short.parseShort(prop)) : null;
    }

    public Short getShort(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Short.valueOf(Short.parseShort(prop)) : null;
    }

    public ChronicleLogLevel getLevel(String loggerName) {
        return this.getLevel(loggerName, null);
    }

    public ChronicleLogLevel getLevel(String loggerName, ChronicleLogLevel defVal) {
        String prop = this.getString(loggerName, KEY_LEVEL);
        return prop != null ? ChronicleLogLevel.fromStringLevel(prop) : defVal;
    }
}

