/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.tools;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.tools.ChronicleLogProcessor;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.MessageFormatter;

public class ChronicleLogReader {
    private static final SimpleDateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final ChronicleQueue cq;

    public ChronicleLogReader(@NotNull String path) {
        this(path, WireType.BINARY_LIGHT);
    }

    public ChronicleLogReader(@NotNull String path, @NotNull WireType wireType) {
        this.cq = ChronicleQueue.singleBuilder((String)path).wireType(wireType).build();
    }

    public static void printf(long timestamp, ChronicleLogLevel level, String loggerName, String threadName, String message, @Nullable Throwable throwable, Object[] args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        if (throwable == null) {
            System.out.printf("%s [%s] [%s] [%s] %s%n", tsFormat.format(timestamp), level.toString(), threadName, loggerName, message);
        } else {
            System.out.printf("%s [%s] [%s] [%s] %s%n%s%n", tsFormat.format(timestamp), level.toString(), threadName, loggerName, message, throwable.toString());
        }
    }

    public void processLogs(@NotNull ChronicleLogProcessor processor, boolean waitForIt) {
        ExcerptTailer tailer = this.cq.createTailer();
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                Wire wire = dc.wire();
                if (wire == null) {
                    if (!waitForIt) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                long timestamp = wire.read("ts").int64();
                ChronicleLogLevel level = (ChronicleLogLevel)wire.read("level").asEnum(ChronicleLogLevel.class);
                String threadName = wire.read("threadName").text();
                String loggerName = wire.read("loggerName").text();
                String message = wire.read("message").text();
                Throwable th = wire.hasMore() ? wire.read("throwable").throwable(false) : null;
                ArrayList argsL = new ArrayList();
                if (wire.hasMore()) {
                    wire.read("args").sequence(argsL, (l, vi) -> {
                        while (vi.hasNextSequenceItem()) {
                            l.add(vi.object(Object.class));
                        }
                    });
                }
                Object[] args = argsL.toArray(new Object[argsL.size()]);
                processor.process(timestamp, level, threadName, loggerName, message, th, args);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
    }
}

