/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.logger.VanillaLogAppenderConfig;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.chronicle.logger.log4j2.BinaryChronicleAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="BinaryVanillaChronicle", category="Core", elementType="appender", printObject=true)
public class BinaryVanillaChronicleAppender
extends BinaryChronicleAppender {
    private final VanillaLogAppenderConfig config;

    public BinaryVanillaChronicleAppender(String name, Filter filter, String path, VanillaLogAppenderConfig config) {
        super(name, filter, path);
        this.config = config;
    }

    @Override
    protected Chronicle createChronicle() throws IOException {
        return this.config != null ? new VanillaChronicle(this.getPath(), this.config.cfg()) : new VanillaChronicle(this.getPath());
    }

    @Override
    protected ExcerptAppender getAppender() {
        try {
            return this.chronicle.createAppender();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected VanillaLogAppenderConfig getChronicleConfig() {
        return this.config;
    }

    @PluginFactory
    public static BinaryVanillaChronicleAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="path") String path, @PluginAttribute(value="formatMessage") String formatMessage, @PluginAttribute(value="includeCallerData") String includeCallerData, @PluginAttribute(value="includeMappedDiagnosticContext") String includeMappedDiagnosticContext, @PluginElement(value="vanillaChronicleConfig") AbstractChronicleAppender.VanillaChronicleCfg chronicleConfig, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for BinaryVanillaChronicleAppender");
            return null;
        }
        if (path == null) {
            LOGGER.error("No path provided for BinaryVanillaChronicleAppender");
            return null;
        }
        BinaryVanillaChronicleAppender appender = new BinaryVanillaChronicleAppender(name, filter, path, chronicleConfig);
        if (formatMessage != null) {
            appender.setFormatMessage("true".equalsIgnoreCase(formatMessage));
        }
        if (includeCallerData != null) {
            appender.setIncludeCallerData("true".equalsIgnoreCase(includeCallerData));
        }
        if (includeMappedDiagnosticContext != null) {
            appender.setIncludeMappedDiagnosticContext("true".equalsIgnoreCase(includeMappedDiagnosticContext));
        }
        return appender;
    }
}

