/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.TimeStampFormatter;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.lang.io.ByteStringAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;

public abstract class TextChronicleAppender
extends AbstractChronicleAppender {
    private String dateFormat = null;
    private TimeStampFormatter timeStampFormatter = null;
    private int stackTraceDepth = -1;

    protected TextChronicleAppender(String name, Filter filter, String path) {
        super(name, filter, path);
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.timeStampFormatter = TimeStampFormatter.fromDateFormat((String)dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setStackTraceDepth(int stackTraceDepth) {
        this.stackTraceDepth = stackTraceDepth;
    }

    public int getStackTraceDepth() {
        return this.stackTraceDepth;
    }

    public void append(LogEvent event) {
        ExcerptAppender appender = this.getAppender();
        if (appender != null) {
            appender.startExcerpt();
            this.timeStampFormatter.format(event.getTimeMillis(), (ByteStringAppender)appender);
            appender.append('|');
            TextChronicleAppender.toChronicleLogLevel(event.getLevel()).printTo((ByteStringAppender)appender);
            appender.append('|');
            appender.append((CharSequence)event.getThreadName());
            appender.append('|');
            appender.append((CharSequence)event.getLoggerName());
            appender.append('|');
            appender.append((CharSequence)event.getMessage().getFormattedMessage());
            Throwable th = event.getThrown();
            if (th != null) {
                appender.append((CharSequence)" - ");
                ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)th, (String)", ", (int)this.stackTraceDepth);
            }
            appender.append('\n');
            appender.finish();
        }
    }
}

