/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j1;

import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.ThrowableInformation;

public abstract class AbstractChronicleAppender
implements Appender,
OptionHandler {
    protected ChronicleLogWriter writer = null;
    private Filter filter;
    private String name = null;
    private ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    private String path = null;
    private String wireType;

    protected AbstractChronicleAppender() {
    }

    public static ChronicleLogLevel toChronicleLogLevel(Level level) {
        switch (level.toInt()) {
            case 10000: {
                return ChronicleLogLevel.DEBUG;
            }
            case 5000: {
                return ChronicleLogLevel.TRACE;
            }
            case 20000: {
                return ChronicleLogLevel.INFO;
            }
            case 30000: {
                return ChronicleLogLevel.WARN;
            }
            case 40000: {
                return ChronicleLogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException(level.toInt() + " not a valid level value");
    }

    public void activateOptions() {
        if (this.path != null) {
            try {
                this.writer = this.createWriter();
            }
            catch (IOException e) {
                LogLog.warn((String)("Exception [" + this.name + "]."), (Throwable)e);
            }
        } else {
            LogLog.warn((String)("path option not set for appender [" + this.name + "]."));
        }
    }

    public void addFilter(Filter newFilter) {
        if (this.filter == null) {
            this.filter = newFilter;
        } else {
            this.filter.setNext(newFilter);
        }
    }

    public void clearFilters() {
        this.filter = null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getWireType() {
        return this.wireType;
    }

    public void setWireType(String wireType) {
        this.wireType = wireType;
    }

    protected void finalize() {
        if (this.writer == null) {
            LogLog.debug((String)("Finalizing appender named [" + this.name + "]."));
            this.close();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            LogLog.warn((String)"You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Layout getLayout() {
        return null;
    }

    public void setLayout(Layout layout) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void doAppend(LoggingEvent event) {
        if (this.writer != null) {
            for (Filter f = this.filter; f != null; f = f.getNext()) {
                switch (f.decide(event)) {
                    case -1: {
                        return;
                    }
                    case 1: {
                        f = null;
                    }
                }
            }
            Throwable throwable = null;
            ThrowableInformation ti = event.getThrowableInformation();
            if (ti != null) {
                throwable = ti.getThrowable();
            }
            this.writer.write(AbstractChronicleAppender.toChronicleLogLevel(event.getLevel()), event.getTimeStamp(), event.getThreadName(), event.getLoggerName(), event.getMessage().toString(), throwable, new Object[0]);
        } else {
            LogLog.error((String)("Attempted to append to closed appender named [" + this.name + "]."));
        }
    }

    protected abstract ChronicleLogWriter createWriter() throws IOException;

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LogLog.warn((String)"Failed to close the writer", (Throwable)e);
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

