/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j1;

import java.io.IOException;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.ThrowableInformation;

public abstract class AbstractChronicleAppender
implements Appender,
OptionHandler {
    private Filter filter;
    private String name = null;
    private ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    protected ChronicleLogWriter writer = null;
    private String path = null;

    protected AbstractChronicleAppender() {
    }

    public void activateOptions() {
        if (this.path != null) {
            try {
                this.writer = this.createWriter();
            }
            catch (IOException e) {
                LogLog.warn((String)("Exception [" + this.name + "]."), (Throwable)e);
            }
        } else {
            LogLog.warn((String)("path option not set for appender [" + this.name + "]."));
        }
    }

    public void addFilter(Filter newFilter) {
        if (this.filter == null) {
            this.filter = newFilter;
        } else {
            this.filter.setNext(newFilter);
        }
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void finalize() {
        if (this.writer == null) {
            LogLog.debug((String)("Finalizing appender named [" + this.name + "]."));
            this.close();
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Layout getLayout() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            LogLog.warn((String)"You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh;
        }
    }

    public void setLayout(Layout layout) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void doAppend(LoggingEvent event) {
        Throwable throwable;
        if (this.writer != null) {
            for (Filter f = this.filter; f != null; f = f.getNext()) {
                switch (f.decide(event)) {
                    case -1: {
                        return;
                    }
                    case 1: {
                        f = null;
                    }
                }
            }
            throwable = null;
            ThrowableInformation ti = event.getThrowableInformation();
            if (ti != null) {
                throwable = ti.getThrowable();
            }
        } else {
            LogLog.error((String)("Attempted to append to closed appender named [" + this.name + "]."));
            return;
        }
        this.writer.write(AbstractChronicleAppender.toChronicleLogLevel(event.getLevel()), event.getTimeStamp(), event.getThreadName(), event.getLoggerName(), event.getMessage().toString(), throwable);
    }

    protected abstract ChronicleLogWriter createWriter() throws IOException;

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LogLog.warn((String)"Failed to close the writer", (Throwable)e);
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public static ChronicleLogLevel toChronicleLogLevel(Level level) {
        switch (level.toInt()) {
            case 10000: {
                return ChronicleLogLevel.DEBUG;
            }
            case 5000: {
                return ChronicleLogLevel.TRACE;
            }
            case 20000: {
                return ChronicleLogLevel.INFO;
            }
            case 30000: {
                return ChronicleLogLevel.WARN;
            }
            case 40000: {
                return ChronicleLogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException(level.toInt() + " not a valid level value");
    }
}

