/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.jul.ChronicleHelper;

class ChronicleLogger
extends Logger {
    protected final String name;
    protected final ChronicleLogWriter writer;
    protected final ChronicleLogLevel level;

    ChronicleLogger(ChronicleLogWriter writer, String name, ChronicleLogLevel level) {
        super(name, null);
        this.writer = writer;
        this.name = name;
        this.level = level;
        this.setLevel(level);
    }

    private void setLevel(ChronicleLogLevel level) {
        super.setLevel(ChronicleHelper.getLogLevel(level));
    }

    String name() {
        return this.name;
    }

    ChronicleLogWriter writer() {
        return this.writer;
    }

    ChronicleLogLevel level() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setParent(Logger parent) {
        throw new UnsupportedOperationException("Cannot set parent logger");
    }

    @Override
    public void log(LogRecord record) {
        this.append(record);
    }

    @Override
    public void log(Level level, String msg) {
        this.append(level, msg);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.append(level, msg, param1);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        this.append(level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        this.append(level, msg, thrown);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.append(level, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.append(level, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.append(level, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.append(level, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.append(level, msg);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.append(level, msg, param1);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.append(level, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.append(level, msg, thrown);
    }

    @Override
    public void severe(String msg) {
        this.append(Level.SEVERE, msg);
    }

    @Override
    public void warning(String msg) {
        this.append(Level.WARNING, msg);
    }

    @Override
    public void info(String msg) {
        this.append(Level.INFO, msg);
    }

    @Override
    public void config(String msg) {
        this.append(Level.CONFIG, msg);
    }

    @Override
    public void fine(String msg) {
        this.append(Level.FINE, msg);
    }

    @Override
    public void finer(String msg) {
        this.append(Level.FINER, msg);
    }

    @Override
    public void finest(String msg) {
        this.append(Level.FINEST, msg);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.isLoggable(ChronicleHelper.getLogLevel(level));
    }

    public boolean isLoggable(ChronicleLogLevel level) {
        return level.isHigherOrEqualTo(this.level);
    }

    protected void append(LogRecord record) {
        ChronicleLogLevel clevel = ChronicleHelper.getLogLevel(record);
        if (this.isLoggable(clevel)) {
            this.writer.write(clevel, record.getMillis(), "thread-" + record.getThreadID(), record.getLoggerName(), record.getMessage(), record.getThrown(), record.getParameters());
        }
    }

    protected void append(Level level, String msg) {
        ChronicleLogLevel clevel = ChronicleHelper.getLogLevel(level);
        if (this.isLoggable(clevel)) {
            this.writer.write(clevel, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, msg);
        }
    }

    protected void append(Level level, String msg, Object ... params) {
        ChronicleLogLevel clevel = ChronicleHelper.getLogLevel(level);
        if (this.isLoggable(clevel)) {
            this.writer.write(clevel, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, msg, null, params);
        }
    }

    protected void append(Level level, String msg, Throwable thrown) {
        ChronicleLogLevel clevel = ChronicleHelper.getLogLevel(level);
        if (this.isLoggable(clevel)) {
            this.writer.write(clevel, System.currentTimeMillis(), Thread.currentThread().getName(), this.name, msg, thrown, new Object[0]);
        }
    }

    public static class Null
    extends ChronicleLogger {
        public static final ChronicleLogger INSTANCE = new Null();

        private Null() {
            super(null, null, null);
        }

        @Override
        protected void append(LogRecord record) {
        }

        @Override
        protected void append(Level level, String msg) {
        }

        @Override
        protected void append(Level level, String msg, Object ... params) {
        }

        @Override
        protected void append(Level level, String msg, Throwable thrown) {
        }
    }
}

