/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import net.openhft.chronicle.logger.LogAppenderConfig;

public class ChronicleHandlerConfig {
    private final LogManager manager = LogManager.getLogManager();
    private final String prefix;

    public ChronicleHandlerConfig(Class<?> type) {
        this.prefix = type.getName();
    }

    public String getString(String name, String defaultValue) {
        return this.getStringProperty(this.prefix + "." + name, defaultValue);
    }

    public int getInt(String name, int defaultValue) {
        return this.getIntProperty(this.prefix + "." + name, defaultValue);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBooleanProperty(this.prefix + "." + name, defaultValue);
    }

    public Level getLevel(String name, Level defaultValue) {
        return this.getLevelProperty(this.prefix + "." + name, defaultValue);
    }

    public Filter getFilter(String name, Filter defaultValue) {
        return this.getFilterProperty(this.prefix + "." + name, defaultValue);
    }

    public LogAppenderConfig getAppenderConfig() {
        LogAppenderConfig cfg = new LogAppenderConfig();
        for (String key : cfg.keys()) {
            cfg.setProperty(key, this.getStringProperty(this.prefix + ".cfg." + key, null));
        }
        return cfg;
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return this.resolvePlaceholder(val.trim());
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getStringProperty(name, null);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    private String resolvePlaceholder(String placeholder) {
        int startIndex = 0;
        int endIndex = 0;
        do {
            if ((startIndex = placeholder.indexOf("${", endIndex)) == -1 || (endIndex = placeholder.indexOf("}", startIndex)) == -1) continue;
            String envKey = placeholder.substring(startIndex + 2, endIndex);
            String newVal = null;
            if (System.getProperties().containsKey(envKey)) {
                newVal = System.getProperties().getProperty(envKey);
            }
            if (newVal == null) continue;
            placeholder = placeholder.replace("${" + envKey + "}", newVal);
            endIndex += newVal.length() - envKey.length() + 3;
        } while (startIndex != -1 && endIndex != -1 && endIndex < placeholder.length());
        return placeholder;
    }
}

