/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.DefaultChronicleLogWriter;
import net.openhft.chronicle.logger.LogAppenderConfig;
import net.openhft.chronicle.logger.jul.AbstractChronicleHandler;
import net.openhft.chronicle.logger.jul.ChronicleHandlerConfig;
import net.openhft.chronicle.logger.jul.ChronicleHelper;

public class ChronicleHandler
extends AbstractChronicleHandler {
    public ChronicleHandler() throws IOException {
        ChronicleHandlerConfig handlerCfg = new ChronicleHandlerConfig(this.getClass());
        String appenderPath = handlerCfg.getString("path", null);
        LogAppenderConfig appenderCfg = handlerCfg.getAppenderConfig();
        this.setLevel(handlerCfg.getLevel("level", Level.ALL));
        this.setFilter(handlerCfg.getFilter("filter", null));
        this.setWriter((ChronicleLogWriter)new DefaultChronicleLogWriter(appenderCfg.build(appenderPath, handlerCfg.getStringProperty("wireType", "BINARY_LIGHT"))));
    }

    @Override
    protected void doPublish(LogRecord record, ChronicleLogWriter writer) {
        writer.write(ChronicleHelper.getLogLevel(record), record.getMillis(), "thread-" + record.getThreadID(), record.getLoggerName(), record.getMessage(), record.getThrown(), record.getParameters());
    }
}

