/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.jul;

import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.openhft.chronicle.logger.ChronicleLogWriter;

abstract class AbstractChronicleHandler
extends Handler {
    private String path = null;
    private ChronicleLogWriter writer = null;

    protected AbstractChronicleHandler() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.writer != null && this.isLoggable(record)) {
            this.doPublish(record, this.writer);
        }
    }

    protected abstract void doPublish(LogRecord var1, ChronicleLogWriter var2);

    protected final void setWriter(ChronicleLogWriter appender) {
        this.writer = appender;
    }

    @Override
    public final void setFilter(Filter newFilter) {
        super.setFilter(newFilter);
    }

    @Override
    public final synchronized void setLevel(Level newLevel) {
        super.setLevel(newLevel);
    }
}

