/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import com.koloboke.function.IntObjConsumer;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.decentred.api.SystemMessages;
import net.openhft.chronicle.decentred.dto.DtoAliases;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import net.openhft.chronicle.decentred.util.DtoParselet;
import net.openhft.chronicle.decentred.util.DtoParser;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.decentred.util.IntObjMap;
import net.openhft.chronicle.decentred.util.VanillaDtoParser;

public final class VanillaDtoRegistry<T>
implements DtoRegistry<T> {
    private final Class<T> superInterface;
    private final Map<Class, Integer> classToProtocolMessageType = new LinkedHashMap<Class, Integer>();
    private final IntObjMap<DtoParselet> parseletMap = IntObjMap.withExpectedSize(DtoParselet.class, 128);
    private final Map<Class, Method> classConsumerMap = new LinkedHashMap<Class, Method>();

    VanillaDtoRegistry(Class<T> superInterface) {
        this.superInterface = Objects.requireNonNull(superInterface);
        this.addProtocol(65535, SystemMessages.class);
    }

    @Override
    public VanillaDtoRegistry<T> addProtocol(int protocol, Class<? super T> pClass) {
        if (protocol < 0) {
            throw new IllegalArgumentException("protocol cannot be negative:" + protocol);
        }
        Objects.requireNonNull(pClass);
        for (Method method : pClass.getMethods()) {
            MethodId mid = method.getAnnotation(MethodId.class);
            if (mid == null) continue;
            assert ((mid.value() | 0xFFFFL) == 65535L);
            int key = (int)((long)(protocol << 16) + mid.value());
            try {
                this.parseletMap.justPut(key, new DtoParselet(method, protocol, Maths.toUInt16((long)mid.value())));
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    Jvm.warn().on(this.getClass(), "Methods must have 1 parameter " + method);
                    continue;
                }
                Class<?> parameterType = parameterTypes[0];
                this.classToProtocolMessageType.put(parameterType, key);
                this.classConsumerMap.putIfAbsent(parameterType, method);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    @Override
    public int protocolFor(Class clazz) {
        return this.protocolMessageTypeFor(clazz) >>> 16;
    }

    @Override
    public int messageTypeFor(Class clazz) {
        return this.protocolMessageTypeFor(clazz) & 0xFFFF;
    }

    @Override
    public int protocolMessageTypeFor(Class clazz) {
        Objects.requireNonNull(clazz);
        Integer pmt = this.classToProtocolMessageType.get(clazz);
        if (pmt == null) {
            throw new IllegalStateException(clazz + " not defined");
        }
        return pmt;
    }

    @Override
    public DtoParser<T> get() {
        IntObjMap<DtoParselet> parseletMap2 = IntObjMap.withExpectedSize(DtoParselet.class, this.parseletMap.size() * 2);
        this.parseletMap.forEach((IntObjConsumer<DtoParselet>)((IntObjConsumer)(i, dp) -> parseletMap2.justPut(i, new DtoParselet((DtoParselet)dp))));
        return new VanillaDtoParser<T>(this.superInterface, parseletMap2, this.classConsumerMap);
    }

    @Override
    public <M extends VanillaSignedMessage<M>> M create(Class<M> tClass) {
        Objects.requireNonNull(tClass);
        int pmt = this.protocolMessageTypeFor(tClass);
        try {
            int protocol = pmt >>> 16;
            int messageType = pmt & 0xFFFF;
            VanillaSignedMessage vsm = (VanillaSignedMessage)ObjectUtils.newInstance(tClass);
            return (M)((VanillaSignedMessage)vsm.protocol(protocol)).messageType(messageType);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Class<T> superInterface() {
        return this.superInterface;
    }

    static {
        DtoAliases.addAliases();
    }
}

