/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import com.koloboke.function.IntObjConsumer;
import net.openhft.chronicle.decentred.util.IntObjMap;

public class SmallIntObjMap<V>
extends IntObjMap<V> {
    private final int[] keys;
    private final V[] values;
    private int size = 0;

    public SmallIntObjMap(int capacity) {
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    @Override
    public void justPut(int key, V value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            this.values[i] = value;
            return;
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    @Override
    public V get(int key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(int key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public void forEach(IntObjConsumer<? super V> longObjConsumer) {
        for (int i = 0; i < this.size; ++i) {
            longObjConsumer.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.keys[i]).append("=").append(this.values[i]);
        }
        sb.append("}");
        return sb.toString();
    }
}

