/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import java.util.Arrays;

public enum LetterBase32 {

    private static final int MASK_5 = 31;
    private static final ThreadLocal<StringBuilder> SB_TL = ThreadLocal.withInitial(StringBuilder::new);
    private static final byte[] VALUES = new byte[128];
    private static final char[] ENCODE = ".abcdefghijklmnopqrstuvwxyz23467".toCharArray();

    public static long decode(CharSequence text) {
        long value = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte code = VALUES[text.charAt(i)];
            if (code < 0) {
                throw new IllegalArgumentException("Cannot decode " + text);
            }
            value = (value << 5) + (long)(code & 0xFF);
        }
        return value;
    }

    public static String encode(long value) {
        StringBuilder sb = SB_TL.get();
        sb.setLength(0);
        LetterBase32.encode(sb, value);
        return sb.toString();
    }

    public static void encode(StringBuilder sb, long value) {
        int start = sb.length();
        do {
            sb.append(ENCODE[(int)(value & 0x1FL)]);
        } while ((value >>>= 5) != 0L);
        for (int end = sb.length() - 1; start < end; ++start, --end) {
            char t = sb.charAt(start);
            sb.setCharAt(start, sb.charAt(end));
            sb.setCharAt(end, t);
        }
    }

    static {
        Arrays.fill(VALUES, (byte)-1);
        for (int i = 0; i < ENCODE.length; ++i) {
            LetterBase32.VALUES[LetterBase32.ENCODE[i]] = (byte)i;
            LetterBase32.VALUES[Character.toUpperCase((char)LetterBase32.ENCODE[i])] = (byte)i;
        }
        LetterBase32.VALUES[64] = 0;
        LetterBase32.VALUES[48] = VALUES[111];
        LetterBase32.VALUES[49] = VALUES[108];
        LetterBase32.VALUES[53] = VALUES[83];
        LetterBase32.VALUES[56] = VALUES[66];
        LetterBase32.VALUES[57] = VALUES[113];
    }
}

