/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.decentred.util.LetterBase32;

public enum DecentredUtil {

    public static final long MASK_32 = 0xFFFFFFFFL;
    public static final int MASK_16 = 65535;
    static final long ADDRESS_MASK = 0x1FFFFFFFFFFFFFFFL;
    static final long TOP_3 = -2305843009213693952L;
    private static final int MASK_8 = 255;

    public static long parseAddress(CharSequence text) {
        switch (DecentredUtil.count(text, ':')) {
            case 0: {
                return DecentredUtil.parseBase32(text);
            }
            case 1: {
                return DecentredUtil.parseIpPort(text.toString());
            }
            case 2: {
                return DecentredUtil.parseIpPortKey(text.toString());
            }
        }
        throw new IllegalArgumentException("Not an address format '" + text + "'");
    }

    private static int count(CharSequence cs, char ch) {
        int n = 0;
        for (int i = 0; i < cs.length(); ++i) {
            if (ch != cs.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static long parseBase32(CharSequence cs) {
        return LetterBase32.decode(cs) | 0xE000000000000000L;
    }

    private static long parseIpPortKey(String text) {
        int last = text.lastIndexOf(58);
        return DecentredUtil.parseIpPort(text.substring(0, last)) + (long)Integer.parseInt(text.substring(last + 1), 16);
    }

    private static long parseIpPort(String text) {
        try {
            int last = text.lastIndexOf(58);
            InetAddress address = InetAddress.getByName(text.substring(0, last));
            int port = Integer.parseInt(text.substring(last + 1));
            return ((long)address.hashCode() << 32) + (long)((port & 0xFFFF) << 16);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Not an address format '" + text + "'", e);
        }
    }

    public static long toAddress(BytesStore publicKey) {
        return publicKey.readLong(publicKey.readLimit() - 8L);
    }

    public static BytesStore testPrivateKey(long seed) {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        privateKey.zeroOut(0L, 32L);
        privateKey.writeSkip(24L);
        privateKey.writeLong(seed);
        return privateKey;
    }

    public static String toAddressString(long address) {
        StringBuilder sb = new StringBuilder(13);
        DecentredUtil.appendAddress(sb, address);
        return sb.toString();
    }

    public static void appendAddress(StringBuilder text, long value) {
        if (DecentredUtil.isAddressNamed(value)) {
            DecentredUtil.base32(text, value & 0x1FFFFFFFFFFFFFFFL);
        } else {
            DecentredUtil.ipPortKey(text, value);
        }
    }

    public static boolean isAddressNamed(long value) {
        return (value & 0xE000000000000000L) == -2305843009213693952L;
    }

    private static void base32(StringBuilder text, long value) {
        LetterBase32.encode(text, value & 0x1FFFFFFFFFFFFFFFL);
    }

    private static void ipPortKey(StringBuilder text, long value) {
        AppendableUtil.append((Appendable)text, (long)(value >> 56 & 0xFFL));
        text.append('.');
        AppendableUtil.append((Appendable)text, (long)(value >> 48 & 0xFFL));
        text.append('.');
        AppendableUtil.append((Appendable)text, (long)(value >> 40 & 0xFFL));
        text.append('.');
        AppendableUtil.append((Appendable)text, (long)(value >> 32 & 0xFFL));
        text.append(':');
        AppendableUtil.append((Appendable)text, (long)(value >> 16 & 0xFFFFL));
        if ((value & 0xFFFFL) != 0L) {
            text.append(':');
            text.append(Integer.toHexString((int)(value & 0xFFFFL)));
        }
    }
}

