/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import java.util.stream.LongStream;
import net.openhft.chronicle.decentred.api.MessageToListener;
import net.openhft.chronicle.decentred.dto.EndOfRoundBlockEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockVoteEvent;
import net.openhft.chronicle.decentred.server.BlockReplayer;
import net.openhft.chronicle.decentred.server.VoteTaker;
import net.openhft.chronicle.decentred.util.LongLongMap;

public class VanillaVoteTaker
implements VoteTaker {
    private final long address;
    private final long[] clusterAddresses;
    private final long chainAddress;
    private final BlockReplayer replayer;
    private LongLongMap addressToBlockNumberMap = LongLongMap.withExpectedSize(16);
    private EndOfRoundBlockEvent endOfRoundBlockEvent = new EndOfRoundBlockEvent();
    private MessageToListener tcpMessageListener;

    public VanillaVoteTaker(long address, long chainAddress, long[] clusterAddresses, BlockReplayer replayer) {
        assert (LongStream.of(clusterAddresses).distinct().count() == (long)clusterAddresses.length);
        this.address = address;
        this.clusterAddresses = clusterAddresses;
        this.chainAddress = chainAddress;
        this.replayer = replayer;
    }

    @Override
    public void transactionBlockVoteEvent(TransactionBlockVoteEvent transactionBlockVoteEvent) {
        LongLongMap addressToBlockNumberMap = transactionBlockVoteEvent.gossipEvent().addressToBlockNumberMap();
        assert (!addressToBlockNumberMap.containsKey(0L));
        this.addressToBlockNumberMap.putAll(addressToBlockNumberMap);
    }

    @Override
    public boolean hasMajority() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendEndOfRoundBlock(long blockNumber) {
        this.endOfRoundBlockEvent.reset();
        ((EndOfRoundBlockEvent)this.endOfRoundBlockEvent.address(this.address)).chainAddress(this.chainAddress);
        VanillaVoteTaker vanillaVoteTaker = this;
        synchronized (vanillaVoteTaker) {
            if (this.addressToBlockNumberMap.size() == 0) {
                return false;
            }
            this.endOfRoundBlockEvent.addressToBlockNumberMap().putAll(this.addressToBlockNumberMap);
        }
        this.endOfRoundBlockEvent.blockNumber(blockNumber);
        for (Object clusterAddress : (VanillaVoteTaker)this.clusterAddresses) {
            if (clusterAddress == this.address) {
                this.replayer.endOfRoundBlockEvent(this.endOfRoundBlockEvent);
                continue;
            }
            this.tcpMessageListener.onMessageTo((long)clusterAddress, this.endOfRoundBlockEvent);
        }
        return true;
    }

    public VanillaVoteTaker tcpMessageListener(MessageToListener tcpMessageListener) {
        this.tcpMessageListener = tcpMessageListener;
        return this;
    }
}

