/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.server;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.decentred.api.Verifier;
import net.openhft.chronicle.decentred.dto.CreateAddressEvent;
import net.openhft.chronicle.decentred.dto.CreateAddressRequest;
import net.openhft.chronicle.decentred.dto.CreateChainRequest;
import net.openhft.chronicle.decentred.dto.CreateTokenRequest;
import net.openhft.chronicle.decentred.dto.EndOfRoundBlockEvent;
import net.openhft.chronicle.decentred.dto.InvalidationEvent;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.dto.TransactionBlockEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockGossipEvent;
import net.openhft.chronicle.decentred.dto.TransactionBlockVoteEvent;
import net.openhft.chronicle.decentred.dto.VerificationEvent;
import net.openhft.chronicle.decentred.remote.net.TCPConnection;
import net.openhft.chronicle.decentred.server.BlockEngine;
import net.openhft.chronicle.decentred.server.DecentredServer;
import net.openhft.chronicle.decentred.server.Gateway;
import net.openhft.chronicle.decentred.server.VanillaBlockEngine;
import net.openhft.chronicle.decentred.server.VanillaVerifyIP;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.decentred.util.PublicKeyRegistry;
import net.openhft.chronicle.decentred.util.VanillaPublicKeyRegistry;

public class VanillaGateway
implements Gateway {
    private static final long MAIN_CHAIN = DecentredUtil.parseAddress("main");
    private final long chainAddress;
    private final BlockEngine main;
    private final BlockEngine local;
    private final VanillaVerifyIP verifyIP;
    private DecentredServer decentredServer;
    private PublicKeyRegistry publicKeyRegistry = new VanillaPublicKeyRegistry();

    public VanillaGateway(long address, long chainAddress, BlockEngine main, BlockEngine local) {
        this.chainAddress = chainAddress;
        this.main = main;
        this.local = local;
        this.verifyIP = new VanillaVerifyIP(addr -> (Verifier)this.decentredServer.to(addr));
    }

    public static <T> VanillaGateway newGateway(DtoRegistry<T> dtoRegistry, long address, String regionStr, long[] clusterAddresses, int mainPeriodMS, int localPeriodMS, T mainTransactionProcessor, T localTransactionPrcoessor) {
        long region = DecentredUtil.parseAddress(regionStr);
        return new VanillaGateway(address, region, VanillaBlockEngine.newMain(dtoRegistry, address, mainPeriodMS, clusterAddresses, mainTransactionProcessor), VanillaBlockEngine.newLocal(dtoRegistry, address, region, localPeriodMS, clusterAddresses, localTransactionPrcoessor));
    }

    @Override
    public void start(DecentredServer decentredServer) {
        this.decentredServer = decentredServer;
        this.main.start(decentredServer);
        this.local.start(decentredServer);
    }

    public void tcpMessageListener(DecentredServer decentredServer) {
        this.decentredServer = decentredServer;
        this.main.tcpMessageListener(decentredServer);
        this.local.tcpMessageListener(decentredServer);
    }

    @UsedViaReflection
    public void processOneBlock() {
        this.main.processOneBlock();
        this.local.processOneBlock();
    }

    @Override
    public void createAddressRequest(CreateAddressRequest createAddressRequest) {
        BytesStore publicKey = createAddressRequest.publicKey();
        long address = DecentredUtil.toAddress(publicKey);
        this.decentredServer.register(address, publicKey);
        this.decentredServer.subscribe(address);
        this.main.onMessage(createAddressRequest);
    }

    @Override
    public void createChainRequest(CreateChainRequest createChainRequest) {
        this.main.createChainRequest(createChainRequest);
    }

    @Override
    public void createTokenRequest(CreateTokenRequest createTokenRequest) {
        this.main.createTokenRequest(createTokenRequest);
    }

    @Override
    public void verificationEvent(VerificationEvent verificationEvent) {
        this.verifyIP.verificationEvent(verificationEvent);
    }

    @Override
    public void invalidationEvent(InvalidationEvent invalidationEvent) {
        this.verifyIP.invalidationEvent(invalidationEvent);
    }

    @Override
    public void transactionBlockEvent(TransactionBlockEvent transactionBlockEvent) {
        long chainAddress = transactionBlockEvent.chainAddress();
        if (this.isMainChain(chainAddress)) {
            this.main.transactionBlockEvent(transactionBlockEvent);
        } else if (this.chainAddress == chainAddress) {
            this.local.transactionBlockEvent(transactionBlockEvent);
        } else {
            System.err.println("Unknown chainAddress " + DecentredUtil.toAddressString(chainAddress));
        }
    }

    private boolean isMainChain(long chainAddress) {
        return chainAddress == MAIN_CHAIN;
    }

    @Override
    public void transactionBlockGossipEvent(TransactionBlockGossipEvent transactionBlockGossipEvent) {
        long chainAddress = transactionBlockGossipEvent.chainAddress();
        if (this.isMainChain(chainAddress)) {
            this.main.transactionBlockGossipEvent(transactionBlockGossipEvent);
        } else if (this.chainAddress == chainAddress) {
            this.local.transactionBlockGossipEvent(transactionBlockGossipEvent);
        } else {
            System.err.println("Unknown chainAddress " + DecentredUtil.toAddressString(chainAddress));
        }
    }

    @Override
    public void transactionBlockVoteEvent(TransactionBlockVoteEvent transactionBlockVoteEvent) {
        long chainAddress = transactionBlockVoteEvent.chainAddress();
        if (this.isMainChain(chainAddress)) {
            this.main.transactionBlockVoteEvent(transactionBlockVoteEvent);
        } else if (this.chainAddress == chainAddress) {
            this.local.transactionBlockVoteEvent(transactionBlockVoteEvent);
        } else {
            System.err.println("Unknown chainAddress " + DecentredUtil.toAddressString(chainAddress));
        }
    }

    @Override
    public void endOfRoundBlockEvent(EndOfRoundBlockEvent endOfRoundBlockEvent) {
        long chainAddress = endOfRoundBlockEvent.chainAddress();
        if (this.isMainChain(chainAddress)) {
            this.main.endOfRoundBlockEvent(endOfRoundBlockEvent);
        } else if (this.chainAddress == chainAddress) {
            this.local.endOfRoundBlockEvent(endOfRoundBlockEvent);
        } else {
            System.err.println("Unknown chainAddress " + this.chainAddress);
        }
    }

    @Override
    public void createAddressEvent(CreateAddressEvent createAddressEvent) {
        this.checkTrusted(createAddressEvent);
        this.publicKeyRegistry.register(createAddressEvent.address(), createAddressEvent.publicKey());
    }

    private void checkTrusted(SignedMessage message) {
    }

    public void close() {
    }

    @Override
    public void onConnection(TCPConnection connection) {
        Gateway.super.onConnection(connection);
        this.verifyIP.onConnection(connection);
    }
}

