/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.remote.rpc;

import com.koloboke.function.LongObjConsumer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.decentred.api.SystemMessageListener;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import net.openhft.chronicle.decentred.remote.net.TCPConnection;
import net.openhft.chronicle.decentred.remote.net.TCPServer;
import net.openhft.chronicle.decentred.remote.net.TCPServerConnectionListener;
import net.openhft.chronicle.decentred.remote.net.VanillaTCPServer;
import net.openhft.chronicle.decentred.server.DecentredServer;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.decentred.util.DtoParser;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.decentred.util.LongObjMap;
import net.openhft.chronicle.decentred.util.PublicKeyRegistry;
import net.openhft.chronicle.decentred.util.VanillaPublicKeyRegistry;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;

public class RPCServer<T>
implements DecentredServer<T>,
Closeable {
    private static final ThreadLocal<TCPConnection> DEFAULT_CONNECTION_TL = new ThreadLocal();
    private final LongObjMap<TCPConnection> connections = LongObjMap.withExpectedSize(TCPConnection.class, 128);
    private final LongObjMap<TCPConnection> remoteMap = LongObjMap.withExpectedSize(TCPConnection.class, 128);
    private final Map<Long, T> allMessagesMap = new ConcurrentHashMap<Long, T>();
    private final PublicKeyRegistry publicKeyRegistry = new VanillaPublicKeyRegistry();
    private final TCPServer tcpServer;
    private final long address;
    private final BytesStore publicKey;
    private final BytesStore secretKey;
    private final Class<T> tClass;
    private final DtoRegistry<T> dtoRegistry;
    private final T serverComponent;

    public RPCServer(String name, int port, long address, BytesStore publicKey, BytesStore secretKey, Class<T> tClass, DtoRegistry<T> dtoRegistry, Function<DecentredServer<T>, T> serverComponentBuilder) throws IOException {
        this.address = address;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.tClass = tClass;
        this.dtoRegistry = dtoRegistry;
        this.tcpServer = new VanillaTCPServer(name, port, new XCLConnectionListener(dtoRegistry.get()));
        this.serverComponent = serverComponentBuilder.apply(this);
    }

    @Override
    public void register(long address, BytesStore publicKey) {
        this.publicKeyRegistry.register(address, publicKey);
    }

    @Override
    public Boolean verify(long address, BytesStore sigAndMsg) {
        return this.publicKeyRegistry.verify(address, sigAndMsg);
    }

    @Override
    public boolean internal() {
        return this.publicKeyRegistry.internal();
    }

    @Override
    public RPCServer internal(boolean internal) {
        this.publicKeyRegistry.internal(internal);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTCPConnection(long addressOrRegion, TCPConnection tcpConnection) {
        System.out.println("Registered " + DecentredUtil.toAddressString(addressOrRegion) + " as " + tcpConnection);
        LongObjMap<TCPConnection> longObjMap = this.remoteMap;
        synchronized (longObjMap) {
            this.remoteMap.justPut(addressOrRegion, tcpConnection);
        }
    }

    @Override
    public void subscribe(long address) {
        this.addTCPConnection(address, DEFAULT_CONNECTION_TL.get());
    }

    @Override
    public T to(long addressOrRegion) {
        ServerInvocationHandler handler = new ServerInvocationHandler(addressOrRegion);
        Object proxy = Proxy.newProxyInstance(this.tClass.getClassLoader(), new Class[]{this.tClass, SystemMessageListener.class}, (InvocationHandler)((Object)handler));
        return (T)proxy;
    }

    private long address() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LongObjMap<TCPConnection> longObjMap = this.connections;
        synchronized (longObjMap) {
            this.connections.forEach((LongObjConsumer<TCPConnection>)((LongObjConsumer)(k, connection) -> Closeable.closeQuietly((Object)connection)));
            this.connections.clear();
        }
        longObjMap = this.remoteMap;
        synchronized (longObjMap) {
            this.remoteMap.forEach((LongObjConsumer<TCPConnection>)((LongObjConsumer)(k, connection) -> Closeable.closeQuietly((Object)connection)));
            this.remoteMap.clear();
        }
        this.tcpServer.close();
    }

    @Override
    public synchronized void onMessageTo(long address, SignedMessage message) {
        System.out.println(Thread.currentThread().getName() + " to " + DecentredUtil.toAddressString(address) + " " + message);
        this.write(address, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(long toAddress, SignedMessage message) {
        TCPConnection tcpConnection;
        if (toAddress == 0L) {
            tcpConnection = DEFAULT_CONNECTION_TL.get();
        } else {
            LongObjMap<TCPConnection> longObjMap = this.connections;
            synchronized (longObjMap) {
                tcpConnection = this.connections.get(toAddress);
            }
            if (tcpConnection == null) {
                longObjMap = this.remoteMap;
                synchronized (longObjMap) {
                    tcpConnection = this.remoteMap.get(toAddress);
                }
            }
        }
        if (tcpConnection == null) {
            String addressString = DecentredUtil.toAddressString(toAddress);
            System.out.println(this.address + " - No connection to address " + addressString + " to send " + message);
            return;
        }
        try {
            if (!message.signed()) {
                if (message.protocol() == 0) {
                    int protocol = this.dtoRegistry.protocolFor(message.getClass());
                    int messageType = this.dtoRegistry.messageTypeFor(message.getClass());
                    ((VanillaSignedMessage)((VanillaSignedMessage)message).protocol(protocol)).messageType(messageType);
                }
                message.sign(this.secretKey);
            }
            tcpConnection.write(((VanillaSignedMessage)message).byteBuffer());
        }
        catch (IllegalStateException e2) {
            e2.printStackTrace();
            System.err.println("Failed to marshall object " + e2.toString());
            throw e2;
        }
        catch (Exception e) {
            e.printStackTrace();
            Closeable.closeQuietly((Object)tcpConnection);
            LongObjMap<TCPConnection> longObjMap = this.connections;
            synchronized (longObjMap) {
                this.connections.justRemove(toAddress);
            }
            Jvm.warn().on(this.getClass(), "Exception while sending message to: " + toAddress + ", message: " + message, (Throwable)e);
        }
    }

    class ServerInvocationHandler
    extends AbstractMethodWriterInvocationHandler {
        final long addressOrRegion;

        ServerInvocationHandler(long addressOrRegion) {
            this.addressOrRegion = addressOrRegion;
        }

        protected void handleInvoke(Method method, Object[] args) {
            assert (args.length == 1);
            VanillaSignedMessage vsm = (VanillaSignedMessage)args[0];
            RPCServer.this.write(this.addressOrRegion, vsm);
        }
    }

    class XCLConnectionListener
    implements TCPServerConnectionListener {
        final DtoParser<T> dtoParser;

        XCLConnectionListener(DtoParser<T> dtoParser) {
            this.dtoParser = dtoParser;
        }

        public void onMessage(TCPServer server, TCPConnection channel, Bytes bytes) throws IOException {
            DEFAULT_CONNECTION_TL.set(channel);
            bytes.readSkip(-4L);
            try {
                this.dtoParser.parseOne(bytes, RPCServer.this.serverComponent);
            }
            catch (IORuntimeException iore) {
                if (iore.getCause() instanceof IOException) {
                    throw (IOException)iore.getCause();
                }
                throw iore;
            }
        }
    }
}

